% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindParameters.R
\name{power_transform}
\alias{power_transform}
\title{Transform values}
\usage{
power_transform(x, transformer = NULL, oob_action = "na", ...)
}
\arguments{
\item{x}{A vector with numeric values that should be transformed to
normality.}

\item{transformer}{A transformer object created using
\code{find_transformation_parameters}. If \code{NULL}, a transformer is generated
internally.}

\item{oob_action}{Action that should be taken when out-of-bounds values are
encountered in \code{x}. This can for example be 0 or negative values for
Box-Cox transformations.
\itemize{
\item \code{na} (default): replaces out-of-bounds values by NA values.
\item \code{valid}: replaces out-of-bounds values by the closest valid boundary
values.
}

This argument has no effect for Yeo-Johnson transformations.}

\item{...}{
  Arguments passed on to \code{\link[=find_transformation_parameters]{find_transformation_parameters}}
  \describe{
    \item{\code{method}}{One of the following methods for power transformation:
\itemize{
\item \code{box_cox}: Transformation using the Box-Cox transformation (Box and Cox,
1964). The Box-Cox transformation requires that all data are strictly
positive. Features that contain zero or negative values cannot be
transformed using this transformation. In their work, Box and Cox define a
shifted variant. We use this variant to shift values to a strictly positive
range, when negative values are present. The Box-Cox transformation relies
on a single parameter lambda, which is estimated through maximisation of
the log-likelihood function corresponding to a normal distribution.
\item \code{yeo_johnson}:Transformation using the Yeo-Johnson
transformation (Yeo and Johnson, 2000). Unlike the Box-Cox transformation,
the Yeo-Johnson transformation allows for negative and positive values.
Like the Box-Cox transformation, this transformation relies on a single
parameter lambda, which is estimated through maximisation of the
log-likelihood function corresponding to a normal distribution.
\item \code{none}: A fall-back method that will not transform values.
}}
    \item{\code{robust}}{Flag for using a robust version of Box-Cox or Yeo-Johnson
transformation, as defined by Raymaekers and Rousseeuw (2021). This version
is less sensitive in the presence outliers.}
    \item{\code{invariant}}{Flag for using a version of Box-Cox or Yeo-Johnson
transformation that simultaneously optimises location and scale in addition
to the lambda parameter.}
    \item{\code{lambda}}{Single lambda value, or range of lambda values that should be
considered. Default: c(4.0, 6.0). Can be \code{NULL} to force optimisation
without a constraint in lambda values.}
    \item{\code{empirical_gof_normality_p_value}}{Significance value for the empirical
goodness-of-fit test for central normality. The p-value is computed through
the \code{assess_transformation} function. By setting this parameter to a
numeric value other than \code{NULL}, the transformation will be rejected when
the p-value of the test is below the significance value.}
  }}
}
\value{
A vector of transformed values of \code{x}.
}
\description{
\code{power_transform} transforms numeric values to normality.
}
\examples{
x <- exp(stats::rnorm(1000))
y <- power_transform(
  x = x,
  method = "box_cox")
}
\seealso{
\link{find_transformation_parameters}
}
