% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverMatrix.R
\name{CoverMatrix}
\alias{CoverMatrix}
\title{Computing the cover matrix of a poset.}
\usage{
CoverMatrix(poset)
}
\arguments{
\item{poset}{An object of S4 class POSet.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A square boolean matrix \eqn{C} (\eqn{C[i,j]=TRUE} if and only if the \eqn{j}-th element of the input poset covers the \eqn{i}-th).
}
\description{
Computes the cover matrix of the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

C <- CoverMatrix(pos)

}
