% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_ASICS_to_PHOENICS.R
\name{from_ASICS_to_PHOENICS}
\alias{from_ASICS_to_PHOENICS}
\title{Prepare quantification data from ASICS outputs}
\usage{
from_ASICS_to_PHOENICS(quantif)
}
\arguments{
\item{quantif}{output matrix of \code{ASICS} quantification}
}
\value{
A matrix of quantification with samples in rows and metabolites in
columns, properly formatted for \code{test_pathway}
}
\description{
Prepare quantification data from \code{ASICS} outputs for
\code{test_pathway}. In short, it replaces metabolite names by metabolites
KEGG codes and transposes the matrix to have samples in rows and metabolites
in columns.
}
\examples{
data("MTBLS422")
quantif <- from_ASICS_to_PHOENICS(quantif)

}
\references{
Lefort G., Liaubet L., Canlet C., Tardivel P., P\`ere M.C., Quesnel H., 
Paris A., Iannuccelli N., Vialaneix N. Servien R. (2019). ASICS: an R
package for a whole analysis workflow of 1D 1H NMR spectra.
\emph{Bioinformatics}, \strong{35}(21): 4356--4363.
\doi{10.1093/bioinformatics/btz248}

Tardivel P., Canlet C., Lefort G., Tremblay-Franco M., Debrauwer L.,
Concordet D., Servien R. (2017). ASICS: an automatic method for
identification and quantification of metabolites in complex 1D 1H NMR
spectra. \emph{Metabolomics}, \strong{13}(10): 109.
\doi{10.1007/s11306-017-1244-5}
}
\author{
Camille Guilmineau <camille.guilmineau@inrae.fr>\cr
Remi Servien <remi.servien@inrae.fr>\cr
Nathalie Vialaneix <nathalie.vialaneix@inrae.fr>
}
