% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{complete_observations}
\alias{complete_observations}
\title{Remove Incomplete Observations from Data Frame}
\usage{
complete_observations(data, id, within, dv)
}
\arguments{
\item{data}{The \code{data.frame} to be processed.}

\item{id}{Character. Name of the column containing the subject identifier.}

\item{within}{Character. Names of the columns containing within-subjects factors.}

\item{dv}{Character. Name of the column containing the dependent variable.}
}
\value{
A \code{data.frame} where NAs and incomplete observations are removed.
It also has up to two additional attributes \code{removed_cases_explicit_NA}
and \code{removed_cases_implicit_NA}, carrying the subject identifiers of
participants whose data has been removed.
}
\description{
This is an internal function that is used to remove incomplete observations
from a \code{data.frame}. It removes (1) explicit NAs and (2) cases with
implicit NAs, i.e. participants who did not provide observations for all
combinations of (possibly multiple) within-subjects factors.
}
\keyword{internal}
