% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPedDirectRelatives.R
\name{getPedDirectRelatives}
\alias{getPedDirectRelatives}
\title{Get the direct ancestors of selected animals from supplied pedigree.}
\usage{
getPedDirectRelatives(ids, ped, unrelatedParents = FALSE)
}
\arguments{
\item{ids}{character vector with Ids.}

\item{ped}{pedigree dataframe object that is used as the source of
pedigree information.}

\item{unrelatedParents}{logical vector when \code{FALSE} the unrelated
parents of offspring do not get a record as an ego; when \code{TRUE}
a place holder record where parent (\code{sire},
\code{dam}) IDs are set to \code{NA}.}
}
\value{
A data.frame with pedigree structure having all of the direct
ancestors for the Ids provided.
}
\description{
Gets direct ancestors from labkey \code{study} schema and \code{demographics}
table.
}
\examples{
library(nprcgenekeepr)
## Have to a vector of focal animals
focalAnimals <- c("1X2701", "1X0101")
suppressWarnings(getLkDirectRelatives(ids = focalAnimals))
}
