% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nfl_team_tiers.R
\name{nfl_team_tiers}
\alias{nfl_team_tiers}
\title{Create NFL Team Tiers}
\usage{
nfl_team_tiers(
  data,
  title = "NFL Team Tiers, 2021 as of Week 4",
  subtitle = "created with the #nflplotR Tiermaker",
  caption = NULL,
  tier_desc = c(`1` = "Super Bowl", `2` = "Very Good", `3` = "Medium", `4` = "Bad", `5` =
    "What are they doing?", `6` = "", `7` = ""),
  presort = FALSE,
  alpha = 0.8,
  width = 0.075,
  no_line_below_tier = NULL,
  devel = FALSE
)
}
\arguments{
\item{data}{A data frame that has to include the variables \code{tier_no} (the
number of the tier starting from the top tier no. 1) and \code{team_abbr} (the
team abbreviation). \code{team_abbr} should be one of \code{\link[=valid_team_names]{valid_team_names()}} and
the function tries to clean team names internally by calling
\code{\link[nflreadr:clean_team_abbrs]{nflreadr::clean_team_abbrs()}}. If data includes the variable \code{tier_rank},
these ranks will be used within each tier. Otherwise, if \code{presort = FALSE},
the function will assume that data is already sorted and if \code{presort = TRUE},
teams will be sorted alphabetically within tiers.}

\item{title}{The title of the plot. If \code{NULL}, it will be omitted.}

\item{subtitle}{The subtitle of the plot. If \code{NULL}, it will be omitted.}

\item{caption}{The caption of the plot. If \code{NULL}, it will be omitted.}

\item{tier_desc}{A named vector consisting of the tier descriptions. The names
must equal the tier numbers from \code{tier_no}}

\item{presort}{If \code{FALSE} (the default) the function assumes that the teams
are already sorted within the tiers. Will otherwise sort alphabetically.}

\item{alpha}{The alpha channel of the logos, i.e. transparency level, as a
numerical value between 0 and 1.}

\item{width}{The desired width of the logo in \code{npc} (Normalised Parent Coordinates).}

\item{no_line_below_tier}{Vector of tier numbers. The function won't draw tier
separation lines below these tiers. This is intended to be used for tiers
that shall be combined (see examples).}

\item{devel}{Determines if logos shall be rendered. If \code{FALSE} (the default),
logos will be rendered on each run. If \code{TRUE} the team abbreviations will be
plotted instead of the logos. This is much faster and helps with the plot
development.}
}
\value{
A plot object created with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
This function sets up a ggplot to visualize NFL team tiers.
}
\examples{
\donttest{
library(ggplot2)
library(data.table)
teams <- nflplotR::valid_team_names()
# remove conference logos from this example
teams <- teams[!teams \%in\% c("AFC", "NFC", "NFL")]
teams <- sample(teams)

# Build the team tiers data
# This is completely random!
dt <- data.table::data.table(
  tier_no = sample(1:5, length(teams), replace = TRUE),
  team_abbr = teams
)[,tier_rank := sample(1:.N, .N), by = "tier_no"]

# Plot team tiers
nfl_team_tiers(dt)

# Create a combined tier which is useful for tiers with lots of teams that
# should be split up in two or more rows. This is done by setting an empty
# string for the tier 5 description and removing the tier separation line
# below tier number 4.
# This example also shows how to turn off the subtitle and add a caption
nfl_team_tiers(dt,
               subtitle = NULL,
               caption = "This is the caption",
               tier_desc = c("1" = "Super Bowl",
                             "2" = "Very Good",
                             "3" = "Medium",
                             "4" = "A Combined Tier",
                             "5" = ""),
               no_line_below_tier = 4)

# For the development of the tiers, it can be useful to turn off logo image
# rendering as this can take quite a long time. By setting `devel = TRUE`, the
# logo images are replaced by team abbreviations which is much faster
nfl_team_tiers(dt,
               tier_desc = c("1" = "Super Bowl",
                             "2" = "Very Good",
                             "3" = "",
                             "4" = "A Combined Tier",
                             "5" = ""),
               no_line_below_tier = c(2, 4),
               devel = TRUE)
}
}
