% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.NeuralGAM.R
\name{print.neuralGAM}
\alias{print.neuralGAM}
\title{Short \code{neuralGAM} summary}
\usage{
\method{print}{neuralGAM}(x, ...)
}
\arguments{
\item{x}{\code{neuralGAM} object.}

\item{\ldots}{Other arguments.}
}
\value{
The printed output of the object:
 \itemize{
 \item Distribution family
 \item Formula
 \item Intercept value
 \item Mean Squared Error (MSE)
 \item Training sample size
}
}
\description{
Default print statement for a neuralGAM object.
}
\examples{
\dontrun{

n <- 24500

seed <- 42
set.seed(seed)

x1 <- runif(n, -2.5, 2.5)
x2 <- runif(n, -2.5, 2.5)
x3 <- runif(n, -2.5, 2.5)

f1 <-x1**2
f2 <- 2*x2
f3 <- sin(x3)
f1 <- f1 - mean(f1)
f2 <- f2 - mean(f2)
f3 <- f3 - mean(f3)

eta0 <- 2 + f1 + f2 + f3
epsilon <- rnorm(n, 0.25)
y <- eta0 + epsilon
train <- data.frame(x1, x2, x3, y)

library(neuralGAM)
ngam <- neuralGAM(y ~ s(x1) + x2 + s(x3), data = train,
                 num_units = 1024, family = "gaussian",
                 activation = "relu",
                 learning_rate = 0.001, bf_threshold = 0.001,
                 max_iter_backfitting = 10, max_iter_ls = 10,
                 seed = seed
                 )
print(ngam)
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo.
}
