# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute summed segment lengths or total cable
#' @description \code{c_seglengths} computes the summed segment length equivalent
#'  to \code{nat::seglengths(sumsegment = T)}
#' @param sl A \code{seglist} with 1-indices into vectors x,y,z
#' @param x,y,z Numeric vectors with 3D coordinate data
#' (which could be columns from a data frame)
#' @export
c_seglengths <- function(sl, x, y, z) {
    .Call(`_natcpp_c_seglengths`, sl, x, y, z)
}

#' @description \code{c_total_cable} computes the summed total cable for a
#' whole neuron. It's intended use is the \code{nat::summary.neuron} function.
#' @rdname c_seglengths
#' @export
c_total_cable <- function(sl, x, y, z) {
    .Call(`_natcpp_c_total_cable`, sl, x, y, z)
}

#' A simple function to compute the lengths of the elements of an R list
#'
#' @details This is equivalent to the \code{base::lengths} however it it much
#' faster for long lists (and somewhat slower for short ones).
#' @param L a list
#' @return An integer vector containing the length of each element of \code{L}
#' @export
c_listlengths <- function(L) {
    .Call(`_natcpp_c_listlengths`, L)
}

#' Find the first and last elements of all vectors in a list
#'
#' @description \code{c_topntail} returns an 2xN matrix containing the start and end
#' of each of the vectors in the input list. Length 0 vectors are ignored, while
#' length 1 vectors are duplicated
#'
#' @param L a list containing integer vectors, typically a \code{seglist}
#' @return For \code{c_topntail} an integer \code{matrix}. For \code{c_topntail_list}
#'   a \code{list}.
#' @export
c_topntail <- function(L) {
    .Call(`_natcpp_c_topntail`, L)
}

#' @description For \code{c_topntail_list}, a list of the same length as
#' \code{L} having the same elements when their length is <=2 or
#' the first and last elements when length>2.
#' @export
#' @rdname c_topntail
c_topntail_list <- function(L) {
    .Call(`_natcpp_c_topntail_list`, L)
}

#' Turn a segment list into an edgelist suitable for constructing an ngraph
#' @details It is up to the caller to generate the \code{seglist}.
#' Note that isolated points will be dropped since they have no edges.
#' @param L a list containing integer vectors from \code{as.seglist}
#' @return An integer matrix of N rows and 2 columns
#' @export
#' @examples
#'
#' \dontrun{
#' library(nat)
#' # make a neuron with multiple subtrees
#' n=prune_vertices(Cell07PNs[[1]], 48L)
#' # Must use flatten=T if including all subtrees
#' sl=as.seglist(n, all = TRUE, flatten = TRUE)
#' c_EdgeListFromSegList(sl)
#' }
c_EdgeListFromSegList <- function(L) {
    .Call(`_natcpp_c_EdgeListFromSegList`, L)
}

