% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_xlsx.R
\name{import_xlsx}
\alias{import_xlsx}
\title{Import Data from \code{XLSX} Files with Advanced Handling}
\usage{
import_xlsx(file, rbind = TRUE, sheet = NULL, ...)
}
\arguments{
\item{file}{A \code{character} vector of file paths to \code{Excel} files.
Must point to existing \code{.xlsx} or \code{.xls} files.}

\item{rbind}{A \code{logical} value controlling data combination strategy:
\itemize{
\item \code{TRUE}: Combines all data into a single \code{data.table}
\item \code{FALSE}: Returns a list of \code{data.table}s
Default is \code{TRUE}.
}}

\item{sheet}{A \code{numeric} vector or \code{NULL} specifying sheet import strategy:
\itemize{
\item \code{NULL} (default): Imports all sheets
\item \code{numeric}: Imports only specified sheet indices
}}

\item{...}{Additional arguments passed to \code{\link[readxl:read_excel]{readxl::read_excel()}},
such as \code{col_types}, \code{skip}, or \code{na}.}
}
\value{
Depends on the \code{rbind} parameter:
\itemize{
\item If \code{rbind = TRUE}: A single \code{data.table} with additional tracking columns:
- \code{excel_name}: Source file name (without extension)
- \code{sheet_name}: Source sheet name
\item If \code{rbind = FALSE}: A named list of \code{data.table}s with format
\code{"filename_sheetname"}
}
}
\description{
A robust and flexible function for importing data from one or multiple
\code{XLSX} files, offering comprehensive options for sheet selection,
data combination, and source tracking.
}
\details{
The function provides a comprehensive solution for importing Excel data with the
following features:
\itemize{
\item Supports multiple files and sheets
\item Automatic source tracking for files and sheets
\item Flexible combining options
\item Handles missing columns across sheets when combining
\item Preserves original data types through readxl
}
}
\note{
Critical Import Considerations:
\itemize{
\item Requires all specified files to be accessible \code{Excel} files
\item Sheet indices must be valid across input files
\item \code{rbind = TRUE} assumes compatible data structures
\item Missing columns are automatically filled with \code{NA}
\item File extensions are automatically removed in tracking columns
}
}
\examples{
# Example: Excel file import demonstrations

# Setup test files
xlsx_files <- mintyr_example(
  mintyr_examples("xlsx_test")    # Get example Excel files
)

# Example 1: Import and combine all sheets from all files
import_xlsx(
  xlsx_files,                     # Input Excel file paths
  rbind = TRUE                    # Combine all sheets into one data.table
)

# Example 2: Import specific sheets separately
import_xlsx(
  xlsx_files,                     # Input Excel file paths
  rbind = FALSE,                  # Keep sheets as separate data.tables
  sheet = 2                       # Only import first sheet
)
}
\seealso{
\itemize{
\item \code{\link[readxl:read_excel]{readxl::read_excel()}} for underlying Excel reading
\item \code{\link[data.table:rbindlist]{data.table::rbindlist()}} for data combination
}
}
