% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regeneration.R
\name{regeneration}
\alias{regeneration}
\alias{regeneration_seedproduction}
\alias{regeneration_seedrefill}
\alias{regeneration_seedmortality}
\alias{regeneration_recruitment}
\alias{regeneration_resprouting}
\title{Plant regeneration}
\usage{
regeneration_seedproduction(forest, SpParams, control)

regeneration_seedrefill(seedBank, refillSpecies, refillPercent = NULL)

regeneration_seedmortality(seedBank, SpParams, minPercent = 1)

regeneration_recruitment(
  forest,
  SpParams,
  control,
  minMonthTemp,
  moistureIndex,
  verbose = FALSE
)

regeneration_resprouting(
  forest,
  internalMortality,
  SpParams,
  control,
  management_results = NULL
)
}
\arguments{
\item{forest}{An object of class \code{\link{forest}}.}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}} and \code{\link{SpParamsDefinition}}).}

\item{control}{A list with default control parameters (see \code{\link{defaultControl}}).}

\item{seedBank}{A data frame with columns 'Species' and 'Percent', describing a seed bank.}

\item{refillSpecies}{A string vector of species names corresponding to seed rain to refill seed bank.}

\item{refillPercent}{A numeric vector of indicating the percentage of seed bank refilling (if missing then seed bank is set to 100\%).}

\item{minPercent}{A minimum percent of seed bank to retain entry in \code{seedBank} element of \code{forest}.}

\item{minMonthTemp}{Minimum month temperature.}

\item{moistureIndex}{Moisture index (annual precipitation over annual potential evapotranspiration).}

\item{verbose}{Boolean flag to indicate console output during calculations.}

\item{internalMortality}{A data frame with mortality occurred in the last year of simulation.}

\item{management_results}{The result of calling a management function (see \code{\link{defaultManagementFunction}}).}
}
\value{
\itemize{
\item{\code{regeneration_seedproduction} returns a list of species names}
\item{\code{regeneration_seedrefill} and \code{regeneration_seedmortality} return a copy of the input \code{data.frame} object with an update seed bank. }
\item{\code{regeneration_resprouting} and \code{regeneration_recruitment} return a new object of class \code{\link{forest}} with the new plant cohorts.}
}
}
\description{
Functions to simulate annual plant regeneration from seed recruitment or from resprouting
}
\details{
\itemize{
\item{\code{regeneration_seedproduction} evaluates if reproductive individuals (i.e. sufficiently tall individuals) are present.}
\item{\code{regeneration_seedrefill} fills seed bank of input \code{forest} object with seed rain.}
\item{\code{regeneration_seedmortality} updates seed bank of input \code{forest} object according to annual seed mortality.}
\item{\code{regeneration_recruitment} evaluates recruitment from the seed bank (or local seed production if seed bank is missing). Minimum month temperature and moisture index values are used to determine if recruitment was successful.
Species also require a minimum amount of light at the ground level.}
\item{\code{regeneration_resprouting} evaluates resprouting occurs after “mortality” from die-back (including drought- or pathogen-induced dessication),
cutting or burning of the aerial part in a species with resprouting ability,
but not after carbon starvation or baseline mortality (unspecific mortality causes).}
}
}
\examples{
#Load example plot plant data
data(exampleforest)

#Default species parameterization
data(SpParamsMED)

#Initialize control parameters
control <- defaultControl("Granier")
control$recruitmentMode = "deterministic" 

#Recruitment limits
plant_parameter(exampleforest, SpParamsMED, "MinTempRecr")
plant_parameter(exampleforest, SpParamsMED, "MinMoistureRecr")

#Compare seed recruitment outcomes
regeneration_recruitment(exampleforest, SpParamsMED, control, 0, 0.25)
regeneration_recruitment(exampleforest, SpParamsMED, control, 3, 0.25)

}
\seealso{
\code{\link{fordyn}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
