% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmeSplines.R
\name{approx.Z}
\alias{approx.Z}
\title{Interpolating in Smoothing Spline Z-Matrix Columns}
\usage{
approx.Z(Z, oldtimes, newtimes)
}
\arguments{
\item{Z}{Z-matrix with rows corresponding to the sorted unique values of the
time covariate (e.g., from \code{\link{smspline}} or \code{\link{smspline.v}}).}

\item{oldtimes}{Numeric vector of original (sorted) time covariate values
corresponding to the rows of \code{Z}.}

\item{newtimes}{Numeric vector of new time covariate values to interpolate to.}
}
\value{
A matrix with the same number of columns as \code{Z} and rows
  corresponding to \code{newtimes}, containing the interpolated Z-matrix values.
  This can be used with \code{\link{smspline}} for fitting LME splines with
  random effects at different time points or as part of the \code{newdata}
  argument in \code{\link[nlme]{predict.lme}} for predictions at new points.
}
\description{
Interpolates the Z-matrix for LME smoothing spline fits from one set of time
covariate values to another using linear interpolation of each column of the
Z-matrix, regarded as a function of time.
}
\note{
Linear interpolation works well because the spline basis functions are
approximately piecewise linear.
}
\examples{
times1 <- 1:10
Zt1 <- smspline(~ times1)
times2 <- seq(1, 10, by = 0.1)
Zt2 <- approx.Z(Zt1, oldtimes = times1, newtimes = times2)

}
\seealso{
\code{\link{smspline}}, \code{\link[nlme]{lme}},
\code{\link[nlme]{predict.lme}}
}
\author{
Rod Ball <rod.ball@scionresearch.com>
}
\keyword{manip}
