% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedPenalty.R
\name{fit}
\alias{fit}
\title{fit}
\usage{
fit(mixedPenalty)
}
\arguments{
\item{mixedPenalty}{object of class mixedPenalty. This object can be created
with the mixedPenalty function. Penalties can be added with the addCappedL1, addElastiNet,
addLasso, addLsp, addMcp, and addScad functions.}
}
\value{
throws error in case of undefined penalty combinations.
}
\description{
Optimizes an object with mixed penalty. See ?mixedPenalty for more details.
}
\examples{
library(lessSEM)

# Identical to regsem, lessSEM builds on the lavaan
# package for model specification. The first step
# therefore is to implement the model in lavaan.

dataset <- simulateExampleData()

lavaanSyntax <- "
f =~ l1*y1 + l2*y2 + l3*y3 + l4*y4 + l5*y5 + 
     l6*y6 + l7*y7 + l8*y8 + l9*y9 + l10*y10 + 
     l11*y11 + l12*y12 + l13*y13 + l14*y14 + l15*y15
f ~~ 1*f
"

lavaanModel <- lavaan::sem(lavaanSyntax,
                           data = dataset,
                           meanstructure = TRUE,
                           std.lv = TRUE)

# We can add mixed penalties as follows:

regularized <- lavaanModel |>
  # create template for regularized model with mixed penalty:
  mixedPenalty() |>
  # add penalty on loadings l6 - l10:
  addElasticNet(regularized = paste0("l", 11:15), 
          lambdas = seq(0,1,.1),
          alphas = .4) |>
  # fit the model:
  fit()
}
