% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_seasplit.R
\name{na_seasplit}
\alias{na_seasplit}
\title{Seasonally Splitted Missing Value Imputation}
\usage{
na_seasplit(
  x,
  algorithm = "interpolation",
  find_frequency = FALSE,
  maxgap = Inf,
  ...
)
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object in which missing values shall be replaced}

\item{algorithm}{Algorithm to be used after splits.
Accepts the following input:
\itemize{
\item{"interpolation" - Imputation by Interpolation} (default choice)
\item{"locf" - Imputation by Last Observation Carried Forward}
\item{"mean" - Imputation by Mean Value}
\item{"random" - Imputation by Random Sample}
\item{"kalman" - Imputation by Kalman Smoothing and State Space Models}
\item{"ma" - Imputation by Weighted Moving Average}
}}

\item{find_frequency}{If TRUE the algorithm will try to estimate the frequency
of the time-series automatically.}

\item{maxgap}{Maximum number of successive NAs to still perform imputation on.
Default setting is to replace all NAs without restrictions. With this
option set, consecutive NAs runs, that are longer than 'maxgap' will
be left NA. This option mostly makes sense if you want to
treat long runs of NA afterwards separately.}

\item{...}{Additional parameters for these algorithms that can be
passed through. Look at \code{\link[imputeTS]{na_interpolation}},
\code{\link[imputeTS]{na_locf}}, \code{\link[imputeTS]{na_random}},
\code{\link[imputeTS]{na_mean}} for parameter options.}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}})
object (dependent on given input at parameter x)
}
\description{
Splits the times series into seasons and afterwards performs
imputation separately for each of the resulting time series datasets
(each containing the data for one specific season).
}
\examples{
# Example 1: Perform seasonal splitted imputation using algorithm = "interpolation"
na_seasplit(tsAirgap, algorithm = "interpolation")

# Example 2: Perform seasonal splitted imputation using algorithm = "mean"
na_seasplit(tsAirgap, algorithm = "mean")

# Example 3: Same as example 1, just written with pipe operator
tsAirgap \%>\% na_seasplit(algorithm = "interpolation")
}
\seealso{
\code{\link[imputeTS]{na_interpolation}},
\code{\link[imputeTS]{na_kalman}}, \code{\link[imputeTS]{na_locf}},
\code{\link[imputeTS]{na_ma}}, \code{\link[imputeTS]{na_mean}},
\code{\link[imputeTS]{na_random}}, \code{\link[imputeTS]{na_replace}},
\code{\link[imputeTS]{na_seadec}}
}
\author{
Steffen Moritz
}
