% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{url_query_parse}
\alias{url_query_parse}
\alias{url_query_build}
\title{Parse query parameters and/or build a string}
\usage{
url_query_parse(query)

url_query_build(query, .multi = c("error", "comma", "pipe", "explode"))
}
\arguments{
\item{query}{A string, when parsing; a named list when building.}

\item{.multi}{Controls what happens when a value is a vector:
\itemize{
\item \code{"error"}, the default, throws an error.
\item \code{"comma"}, separates values with a \verb{,}, e.g. \verb{?x=1,2}.
\item \code{"pipe"}, separates values with a \code{|}, e.g. \code{?x=1|2}.
\item \code{"explode"}, turns each element into its own parameter, e.g. \code{?x=1&x=2}
}

If none of these options work for your needs, you can instead supply a
function that takes a character vector of argument values and returns a
a single string.}
}
\description{
\code{url_query_parse()} parses a query string into a named list;
\code{url_query_build()} builds a query string from a named list.
}
\examples{
str(url_query_parse("a=1&b=2"))

url_query_build(list(x = 1, y = "z"))
url_query_build(list(x = 1, y = 1:2), .multi = "explode")
}
