% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chem.physical_and_invitro.data}
\alias{chem.physical_and_invitro.data}
\title{Physico-chemical properties and in vitro measurements for toxicokinetics}
\format{
A data.frame containing 9411 rows and 54 columns.
\tabular{lll}{
\strong{Column Name} \tab \strong{Description} \tab \strong{Units} \cr
 Compound \tab The preferred name of the chemical compound \tab none \cr                      
 CAS\tab The preferred Chemical Abstracts Service Registry Number \tab none \cr                     
 CAS.Checksum \tab A logical indicating whether the CAS number is valid \tab none \cr                   
 DTXSID \tab DSSTox Structure ID 
(\url{https://comptox.epa.gov/dashboard}) \tab none \cr                  
 Formula \tab The proportions of atoms within the chemical compound  \tab none \cr                   
 All.Compound.Names \tab All names of the chemical as they occured in the
data \tab none \cr                                           
 logHenry \tab The log10 Henry's law constant (Conc_air = 10^logH * Conc_liquid)\tab 
log10(atmosphers*m^3/mole) \cr                 
 logHenry.Reference \tab Reference for Henry's law constant \tab \cr           
 logP \tab The log10 octanol:water partition coefficient (PC)\tab log10 unitless ratio \cr                 
 logP.Reference \tab Reference for logPow \tab \cr               
 logPwa \tab The log10 water:air PC \tab log10 unitless ratio \cr                 
 logPwa.Reference \tab Reference for logPwa \tab \cr             
 logMA \tab The log10 phospholipid:water PC or
"Membrane affinity" \tab unitless ratio \cr                
 logMA.Reference \tab Reference for membrane affinity \tab \cr   
 logWSol \tab The log10 water solubility \tab log10(mole/L) \cr                  
 logWSol.Reference \tab Reference for logWsol \tab \cr              
 MP \tab The chemical compound melting point \tab degrees Celsius \cr                  
 MP.Reference \tab Reference for melting point \tab \cr                   
 MW \tab The chemical compound molecular weight \tab g/mol \cr                
 MW.Reference \tab Reference for molecular weight \tab \cr                 
 pKa_Accept \tab The hydrogen acceptor equilibria concentrations 
 \tab logarithm \cr              
 pKa_Accept.Reference \tab Reference for pKa_Accept \tab \cr           
 pKa_Donor \tab The hydrogen acceptor equilibria concentrations 
\tab logarithm \cr               
 pKa_Donor.Reference \tab Reference for pKa_Donor \tab \cr             
 All.Species \tab All species for which data were available \tab none \cr                
 DTXSID.Reference \tab Reference for DTXSID \tab \cr               
 Formula.Reference \tab Reference for chemical formulat \tab \cr             
 [SPECIES].Clint \tab (Primary hepatocyte suspension) 
intrinsic hepatic clearance. \emph{Entries with comma separated values are Bayesian estimates of
the Clint distribution - displayed as the median, 95th credible interval
(that is quantile 2.5 and 97.5, respectively), and p-value.} \tab uL/min/10^6 hepatocytes \cr                   
 [SPECIES].Clint.pValue \tab Probability that there is no clearance observed.
 Values close to 1 indicate clearance is not statistically significant. \tab none \cr           
 [SPECIES].Clint.pValue.Ref \tab Reference for Clint pValue \tab  \cr   
 [SPECIES].Clint.Reference \tab Reference for Clint \tab  \cr         
 [SPECIES].Caco2.Pab \tab Caco-2 Apical-to-Basal Membrane Permeability \tab 10^-6 cm/s \cr           
 [SPECIES].Caco2.Pab.Reference \tab Reference for Caco-2 Membrane Permeability \tab \cr
 [SPECIES].Fabs \tab In vivo measured fraction of an oral dose of chemical 
absorbed from the gut lumen into the gut \tab unitless fraction \cr           
 [SPECIES].Fabs.Reference \tab Reference for Fabs \tab \cr        
 [SPECIES].Fgut \tab In vivo measured fraction of an oral dose of chemical 
that passes gut metabolism and clearance \tab unitless fraction \cr           
 [SPECIES].Fgut.Reference \tab Reference for Fgut \tab \cr        
 [SPECIES].Foral \tab In vivo measued fractional systemic bioavailability of 
an oral dose, modeled as he product of Fabs * Fgut * Fhep (where Fhep is 
first pass hepatic metabolism). \tab unitless fraction \cr           
 [SPECIES].Foral.Reference \tab Reference for Foral \tab \cr        
 [SPECIES].Funbound.plasma \tab Chemical fraction unbound in presence of 
plasma proteins (fup). \emph{Entries with comma separated values are Bayesian estimates of
the fup distribution - displayed as the median and 95th credible interval
(that is quantile 2.5 and 97.5, respectively).} \tab unitless fraction \cr         
 [SPECIES].Funbound.plasma.Ref\tab Reference for Funbound.plasma \tab \cr 
 [SPECIES].Rblood2plasma \tab Chemical concentration blood to plasma ratio \tab unitless ratio \cr         
 [SPECIES].Rblood2plasma.Ref \tab Reference for Rblood2plasma \tab  \cr        
 Chemical.Class \tab All classes to which the chemical has been assigned \tab \cr
}
}
\source{
Wambaugh, John F., et al. "Toxicokinetic triage for environmental
chemicals." Toxicological Sciences (2015): 228-237.
}
\usage{
chem.physical_and_invitro.data
}
\description{
This data set contains the necessary information to make basic,
high-throughput toxicokinetic (HTTK) predictions for compounds, including
Funbound.plasma, molecular weight (g/mol), logP, logMA (membrane affinity),
intrinsic clearance(uL/min/10^6 cells), and pKa. These data have been
compiled from multiple sources, and can be used to parameterize a variety of
toxicokinetic models. See variable EPA.ref for information on the reference EPA.
}
\details{
In some cases the rapid equilbrium dailysis method (Waters et al., 2008)
fails to yield detectable concentrations for the free fraction of chemical. 
In those cases we assume the compound is highly bound (that is, Fup approaches
zero). For some calculations (for example, steady-state plasma concentration)
there is precendent (Rotroff et al., 2010) for using half the average limit 
of detection, that is 0.005. We do not recomend using other models where 
quantities like partition coefficients must be predicted using Fup. We also
do not recomend including the value 0.005 in training sets for Fup predictive
models. 

\strong{Note} that in some cases the \strong{Funbound.plasma} and the 
\strong{intrinsic clearance} are
\emph{provided as a series of numbers separated by commas}. These values are the 
result of Bayesian analysis and characterize a distribution: the first value
is the median of the distribution, while the second and third values are the 
lower and upper 95th percentile (that is qunatile 2.5 and 97.5) respectively.
For intrinsic clearance a fourth value indicating a p-value for a decrease is
provided. Typically 4000 samples were used for the Bayesian analusis, such
that a p-value of "0" is equivale to "<0.00025". See Wambaugh et al. (2019)
for more details.

Any one chemical compound \emph{may have multiple ionization equilibria} 
(see Strope et al., 2018) may both for donating or accepting a proton (and
therefore changing charge state). If there are multiple equlibria of the same
type (donor/accept])the are concatonated by commas.

All species-specific information is initially from experimental measurements.
The functions \code{\link{load_sipes2017}}, \code{\link{load_pradeep2020}}, 
and \code{\link{load_dawson2021}} may be used to add in silico, structure-based
predictions for many thousands of additional compounds to this table.
}
\references{
CompTox Chemicals Dashboard (\url{https://comptox.epa.gov/dashboard})

EPI Suite, https://www.epa.gov/opptintr/exposure/pubs/episuite.htm

Brown, Hayley S., Michael Griffin, and J. Brian Houston. "Evaluation of 
cryopreserved human hepatocytes as an alternative in vitro system to 
microsomes for the prediction of metabolic clearance." Drug metabolism and 
disposition 35.2 (2007): 293-301.

Gulden, Michael, et al. "Impact of protein binding on the availability and 
cytotoxic potency of organochlorine pesticides and chlorophenols in vitro." 
Toxicology 175.1-3 (2002): 201-213.

Hilal, S., Karickhoff, S. and Carreira, L. (1995). A rigorous test for
SPARC's chemical reactivity models: Estimation of more than 4300 ionization
pKas. Quantitative Structure-Activity Relationships 14(4), 348-355.

\insertRef{honda2019using}{httk}

\insertRef{ito2004comparison}{httk}

Jones, O. A., Voulvoulis, N. and Lester, J. N. (2002). Aquatic environmental
assessment of the top 25 English prescription pharmaceuticals. Water
research 36(20), 5013-22.

Jones, Barry C., et al. "An investigation into the prediction of in vivo 
clearance for a range of flavin-containing monooxygenase substrates." 
Drug metabolism and disposition 45.10 (2017): 1060-1067.

Lau, Y. Y., Sapidou, E., Cui, X., White, R. E. and Cheng, K. C. (2002).
Development of a novel in vitro model to predict hepatic clearance using
fresh, cryopreserved, and sandwich-cultured hepatocytes. Drug Metabolism and
Disposition 30(12), 1446-54.

\insertRef{linakis2020development}{httk}

Lombardo, F., Berellini, G., & Obach, R. S. (2018). Trend analysis of a 
database of intravenous pharmacokinetic parameters in humans for 1352 drug 
compounds. Drug Metabolism and Disposition, 46(11), 1466-1477.

McGinnity, D. F., Soars, M. G., Urbanowicz, R. A. and Riley, R. J. (2004).
Evaluation of fresh and cryopreserved hepatocytes as in vitro drug
metabolism tools for the prediction of metabolic clearance. Drug Metabolism
and Disposition 32(11), 1247-53, 10.1124/dmd.104.000026.

Naritomi, Y., Terashita, S., Kagayama, A. and Sugiyama, Y. (2003). Utility
of Hepatocytes in Predicting Drug Metabolism: Comparison of Hepatic
Intrinsic Clearance in Rats and Humans in Vivo and in Vitro. Drug Metabolism
and Disposition 31(5), 580-588, 10.1124/dmd.31.5.580.

Obach, R. S. (1999). Prediction of human clearance of twenty-nine drugs from
hepatic microsomal intrinsic clearance data: An examination of in vitro
half-life approach and nonspecific binding to microsomes. Drug Metabolism
and Disposition 27(11), 1350-9.

Paini, Alicia; Cole, Thomas; Meinero, Maria; Carpi, Donatella; Deceuninck, 
Pierre; Macko, Peter; Palosaari, Taina; Sund, Jukka; Worth, Andrew; Whelan, 
Maurice (2020):  EURL ECVAM in vitro hepatocyte clearance and blood plasma 
protein binding dataset for 77 chemicals. European Commission, Joint Research 
Centre (JRC) [Dataset] PID: https://data.europa.eu/89h/a2ff867f-db80-4acf-8e5c-e45502713bee

Paixao, P., Gouveia, L. F., & Morais, J. A. (2012). Prediction of the human
oral bioavailability by using in vitro and in silico drug related parameters
in a physiologically based absorption model. International journal of
pharmaceutics, 429(1), 84-98.

Pirovano, Alessandra, et al. "QSARs for estimating intrinsic hepatic
clearance of organic chemicals in humans." Environmental toxicology and
pharmacology 42 (2016): 190-197.

Riley, Robert J., Dermot F. McGinnity, and Rupert P. Austin. "A unified 
model for predicting human hepatic, metabolic clearance from in vitro 
intrinsic clearance data in hepatocytes and microsomes." Drug Metabolism and 
Disposition 33.9 (2005): 1304-1311.

\insertRef{schmitt2008general}{httk}

Shibata, Y., Takahashi, H., Chiba, M. and Ishii, Y. (2002). Prediction of
Hepatic Clearance and Availability by Cryopreserved Human Hepatocytes: An
Application of Serum Incubation Method. Drug Metabolism and Disposition
30(8), 892-896, 10.1124/dmd.30.8.892.

Sohlenius-Sternbeck, Anna-Karin, et al. "Practical use of the regression 
offset approach for the prediction of in vivo intrinsic clearance from 
hepatocytes." Xenobiotica 42.9 (2012): 841-853.

Tonnelier, A., Coecke, S. and Zaldivar, J.-M. (2012). Screening of chemicals
for human bioaccumulative potential with a physiologically based
toxicokinetic model. Archives of Toxicology 86(3), 393-403,
10.1007/s00204-011-0768-0.

Uchimura, Takahide, et al. "Prediction of human blood-to-plasma drug
concentration ratio." Biopharmaceutics & drug disposition 31.5-6 (2010):
286-297.

\insertRef{wambaugh2019assessing}{httk}

\insertRef{wetmore2012integration}{httk}

\insertRef{wetmore2013relative}{httk}

\insertRef{wetmore2015incorporating}{httk}

F. L. Wood, J. B. Houston and D. Hallifax
'Drug Metabolism and Disposition November 1, 2017, 45 (11) 1178-1188; 
DOI: https://doi.org/10.1124/dmd.117.077040
}
\seealso{
\code{\link{get_physchem_param}}

\code{\link{get_invitroPK_param}}

\code{\link{add_chemtable}}
}
\author{
John Wambaugh
}
\keyword{data}
