% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httk-package.R
\docType{package}
\name{httk-package}
\alias{httk}
\alias{httk-package}
\title{httk: High-Throughput Toxicokinetics}
\description{
Pre-made models that can be rapidly tailored to various chemicals and species using chemical-specific in vitro data and physiological information. These tools allow incorporation of chemical toxicokinetics ("TK") and in vitro-in vivo extrapolation ("IVIVE") into bioinformatics, as described by Pearce et al. (2017) (\doi{10.18637/jss.v079.i04}). Chemical-specific in vitro data characterizing toxicokinetics have been obtained from relatively high-throughput experiments. The chemical-independent ("generic") physiologically-based ("PBTK") and empirical (for example, one compartment) "TK" models included here can be parameterized with in vitro data or in silico predictions which are provided for thousands of chemicals, multiple exposure routes, and various species. High throughput toxicokinetics ("HTTK") is the combination of in vitro data and generic models. We establish the expected accuracy of HTTK for chemicals without in vivo data through statistical evaluation of HTTK predictions for chemicals where in vivo data do exist. The models are systems of ordinary differential equations that are developed in MCSim and solved using compiled (C-based) code for speed. A Monte Carlo sampler is included for simulating human biological variability (Ring et al., 2017 \doi{10.1016/j.envint.2017.06.004}) and propagating parameter uncertainty (Wambaugh et al., 2019 \doi{10.1093/toxsci/kfz205}). Empirically calibrated methods are included for predicting tissue:plasma partition coefficients and volume of distribution (Pearce et al., 2017 \doi{10.1007/s10928-017-9548-7}). These functions and data provide a set of tools for using IVIVE to convert concentrations from high-throughput screening experiments (for example, Tox21, ToxCast) to real-world exposures via reverse dosimetry (also known as "RTK") (Wetmore et al., 2015 \doi{10.1093/toxsci/kfv171}).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://www.epa.gov/chemical-research/rapid-chemical-exposure-and-dose-research}
  \item Report bugs at \url{https://github.com/USEPA/CompTox-ExpoCast-httk/issues}
}

}
\author{
\strong{Maintainer}: John Wambaugh \email{wambaugh.john@epa.gov} (\href{https://orcid.org/0000-0002-4024-534X}{ORCID})

Authors:
\itemize{
  \item Sarah Davidson-Fritz \email{davidsonfritz.sarah@epa.gov} (\href{https://orcid.org/0000-0002-2891-9380}{ORCID})
  \item Robert Pearce (\href{https://orcid.org/0000-0003-3168-4049}{ORCID})
  \item Caroline Ring \email{Ring.Caroline@epa.gov} (\href{https://orcid.org/0000-0002-0463-1251}{ORCID})
  \item Greg Honda \email{honda.gregory@epa.gov} (\href{https://orcid.org/0000-0001-7713-9850}{ORCID})
  \item Mark Sfeir
  \item Matt Linakis \email{MLINAKIS@ramboll.com} (\href{https://orcid.org/0000-0003-0526-2395}{ORCID})
  \item Dustin Kapraun \email{kapraun.dustin@epa.gov} (\href{https://orcid.org/0000-0001-5570-6383}{ORCID})
  \item Kimberly Truong \email{truong.kimberly@epa.gov} (\href{https://orcid.org/0000-0003-1716-1006}{ORCID})
  \item Colin Thomson \email{thomson.colin@epa.gov} (\href{https://orcid.org/0000-0001-5303-6646}{ORCID})
}

Other contributors:
\itemize{
  \item Todor Antonijevic \email{tantonijevic@toxstrategies.com} (\href{https://orcid.org/0000-0002-0248-8412}{ORCID}) [contributor]
  \item Miyuki Breen \email{breen.miyuki@epa.gov} (\href{https://orcid.org/0000-0001-8511-4653}{ORCID}) [contributor]
  \item Shannon Bell \email{Shannon.bell@inotivco.com} (\href{https://orcid.org/0000-0002-5754-6085}{ORCID}) [contributor]
  \item Xiaoqing Chang \email{Xiaoqing.chang@inotivco.com} (\href{https://orcid.org/0000-0003-0752-1848}{ORCID}) [contributor]
  \item Jimena Davis [contributor]
  \item Elaina Kenyon \email{kenyon.elaina@epa.gov} (\href{https://orcid.org/0000-0001-8781-2391}{ORCID}) [contributor]
  \item Gilberto Padilla Mercado \email{PadillaMercado.Gilberto@epa.gov} (\href{https://orcid.org/0000-0001-5423-1646}{ORCID}) [contributor]
  \item Katie Paul Friedman \email{Paul-Friedman.Katie@epa.gov} (\href{https://orcid.org/0000-0002-2710-1691}{ORCID}) [contributor]
  \item Nathan Pollesch \email{pollesch.nathan@epa.gov} (\href{https://orcid.org/0000-0001-8992-9294}{ORCID}) [contributor]
  \item Celia Schacht \email{Schacht.Celia@epa.gov} (\href{https://orcid.org/0000-0002-8131-513X}{ORCID}) [contributor]
  \item Meredith Scherer \email{Scherer.Meredith@epa.gov} (\href{https://orcid.org/0000-0002-9785-7363}{ORCID}) [contributor]
  \item Noelle Sinski \email{Noelle.Sinski@icf.com} [contributor]
  \item Nisha Sipes \email{sipes.nisha@epa.gov} (\href{https://orcid.org/0000-0003-4203-6426}{ORCID}) [contributor]
  \item James Sluka \email{jsluka@indiana.edu} (\href{https://orcid.org/0000-0002-5901-1404}{ORCID}) [contributor]
  \item Caroline Stevens \email{stevens.caroline@epa.gov} (\href{https://orcid.org/0000-0001-7780-2691}{ORCID}) [contributor]
  \item Barbara Wetmore \email{wetmore.barbara@epa.gov} (\href{https://orcid.org/0000-0002-6878-5348}{ORCID}) [contributor]
  \item Lily Whipple [contributor]
  \item Woodrow Setzer (\href{https://orcid.org/0000-0002-6709-9186}{ORCID}) [contributor]
}

}
\keyword{internal}
