% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis-size.R
\name{basis_size}
\alias{basis_size}
\alias{basis_size.mgcv.smooth}
\alias{basis_size.gam}
\alias{basis_size.gamm}
\title{Extract basis dimension of a smooth}
\usage{
basis_size(object, ...)

\method{basis_size}{mgcv.smooth}(object, ...)

\method{basis_size}{gam}(object, ...)

\method{basis_size}{gamm}(object, ...)
}
\arguments{
\item{object}{A fitted GAM(M). Currently \code{\link[mgcv:gam]{mgcv::gam()}} (and anything that
inherits from the \code{"gam"} class, e.g. \code{\link[mgcv:bam]{mgcv::bam()}}) and \code{\link[mgcv:gamm]{mgcv::gamm()}} are
supported.}

\item{...}{Arguments passed to other methods.}
}
\description{
Extract basis dimension of a smooth
}
\examples{
load_mgcv()

df <- data_sim("eg1", n = 200, seed = 1)
m <- bam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df)

basis_size(m)
}
