% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key-intervals.r
\name{draw-key}
\alias{draw-key}
\alias{draw_key_line}
\alias{draw_key_crosslines}
\alias{draw_key_crosspoint}
\title{Key drawing functions for bivariate intervals.}
\usage{
draw_key_line(data, params, size)

draw_key_crosslines(data, params, size)

draw_key_crosspoint(data, params, size)
}
\arguments{
\item{data}{A single row data frame containing the scaled aesthetics to
display in this key}

\item{params}{A list of additional parameters supplied to the geom.}

\item{size}{Width and height of key in mm.}
}
\value{
A grid grob.
}
\description{
These key drawing functions supplement those built into
\strong{\link[ggplot2:ggplot2-package]{ggplot2}} for legend glyphs suitable to bivariate
\link[=geom_lineranges]{line-ranges and point-ranges}.
}
\details{
\code{draw_key_line()} is a horizontal counterpart to \code{\link[ggplot2:draw_key]{ggplot2::draw_key_vline()}}.
\code{draw_key_crosslines()} superimposes these two keys, and
\code{draw_key_crosspoint()} additionally superimposes an oversized
\code{\link[ggplot2:draw_key]{ggplot2::draw_key_point()}}.
}
\seealso{
\link[ggplot2:draw_key]{ggplot2::draw_key} for key glyphs installed with \strong{ggplot2}.
}
