% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_exp_exp}
\alias{fn_exp_exp}
\title{Double-exponential function}
\usage{
fn_exp_exp(t, t1, t2, alpha, beta)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{t1}{The onset time of the response. The function is 0 for all values less than \code{t1}.}

\item{t2}{The transition time between the two exponential phases. Must be greater than \code{t1}.}

\item{alpha}{The exponential growth rate during the first phase (\code{t1} to \code{t2}).}

\item{beta}{The exponential growth rate after \code{t2}.}
}
\value{
A numeric vector of the same length as \code{t}, representing the function values.
}
\description{
A piecewise function with two exponential phases. The first exponential phase
occurs between \code{t1} and \code{t2}, and the second phase continues after
\code{t2} with a potentially different growth rate. The function ensures
continuity at the transition point but not necessarily smoothness (in derivative).
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, \alpha, \beta) =
\begin{cases}
0 & \text{if } t < t_1 \\
e^{\alpha \cdot (t - t_1)} - 1 & \text{if } t_1 \leq t \leq t_2 \\
\left(e^{\alpha \cdot (t_2 - t_1)} - 1\right) \cdot e^{\beta \cdot (t - t_2)} & \text{if } t > t_2
\end{cases}
}
}

The function rises from 0 starting at \code{t1} with exponential growth rate
\code{alpha}, and transitions to a second exponential phase with rate
\code{beta} at \code{t2}. The value at the transition point is preserved,
ensuring continuity.
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_exp_exp",
  params = c(t1 = 35, t2 = 55, alpha = 1 / 20, beta = -1 / 30),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3,
  y_auc_label = 0.2
)
}
