% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{mask_function2}
\alias{mask_function2}
\title{Mask a function with given variables}
\usage{
mask_function2(f, ..., .list = list())
}
\arguments{
\item{f}{any function}

\item{..., .list}{name-value pairs to mask the function}
}
\value{
a masked function
}
\description{
Modifies the default behavior of
the function by adding one environment layer on top of input
function. The masked variables are assigned directly to the
environment.
}
\examples{

a <- 123
f1 <- function(){
  a + 1
}
f1()   # 124

f2 <- mask_function2(f1, a = 1)
f2()   # a is masked with value 1, return 2

environment(f1)  # global env
environment(f2)  # masked env

env <- environment(f2)
identical(parent.env(env), environment(f1))  # true
env$a  # masked variables: a=1

}
