% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald_test_bnb.r
\name{wald_test_bnb}
\alias{wald_test_bnb}
\title{Wald test for BNB ratio of means}
\usage{
wald_test_bnb(data, ci_level = NULL, link = "log", ratio_null = 1, ...)
}
\arguments{
\item{data}{(list)\cr
A list whose first element is the vector of negative binomial values
from sample 1 and the second element is the vector of negative
binomial values from sample 2.
Each vector must be sorted by the subject/item index and must be the
same sample size. \link[base]{NA}s are silently excluded. The default
output from \code{\link[=sim_bnb]{sim_bnb()}}.}

\item{ci_level}{(Scalar numeric: \code{NULL}; \verb{(0, 1)})\cr
If \code{NULL}, confidence intervals are set as \code{NA}. If in \verb{(0, 1)},
confidence intervals are calculated at the specified level.}

\item{link}{(Scalar string: \code{"log"})\cr
The one-to-one link function for transformation of the ratio in the
test hypotheses. Must be one of \code{"log"} (default), \code{"sqrt"},
\code{"squared"}, or "\verb{identity"}. See 'Details' for additional information.}

\item{ratio_null}{(Scalar numeric: \code{1}; \verb{(0, Inf)})\cr
The (pre-transformation) ratio of means assumed under the null
hypothesis (sample 2 / sample 1). Typically \code{ratio_null = 1}
(no difference). See 'Details' for additional information.}

\item{...}{Optional arguments passed to the MLE function \code{\link[=mle_bnb]{mle_bnb()}}.}
}
\value{
A list with the following elements:
\tabular{llll}{
Slot \tab Subslot \tab Name \tab Description \cr
1 \tab \tab \code{chisq} \tab \eqn{\chi^2} test statistic for the ratio of means. \cr
2 \tab \tab \code{df} \tab Degrees of freedom. \cr
3 \tab \tab \code{p} \tab p-value. \cr

4 \tab \tab \code{ratio}      \tab Estimated ratio of means (group 2 / group 1). \cr
4 \tab 1 \tab \code{estimate} \tab Point estimate. \cr
4 \tab 2 \tab \code{lower}    \tab Confidence interval lower bound. \cr
4 \tab 3 \tab \code{upper}    \tab Confidence interval upper bound. \cr

5 \tab \tab \code{mean1} \tab Estimated mean of sample 1. \cr
6 \tab \tab \code{mean2} \tab Estimated mean of sample 2. \cr
7 \tab \tab \code{dispersion} \tab Estimated dispersion. \cr
8 \tab \tab \code{n1} \tab The sample size of sample 1. \cr
9 \tab \tab \code{n2} \tab The sample size of sample 2. \cr
10 \tab \tab \code{method} \tab Method used for the results. \cr
11 \tab \tab \code{ci_level} \tab The confidence level. \cr
12 \tab \tab \code{link} \tab Link function used to transform the ratio of means in the test hypotheses. \cr
13 \tab \tab \code{ratio_null} \tab Assumed ratio of means under the null hypothesis. \cr
14 \tab \tab \code{mle_code} \tab Integer indicating why the optimization process terminated. \cr
15 \tab \tab \code{mle_message} \tab Information from the optimizer.
}
}
\description{
Wald test for the ratio of means from bivariate negative binomial outcomes.
}
\details{
This function is primarily designed for speed in simulation. Missing values
are silently excluded.

Suppose \eqn{X_1 \mid G = g \sim \text{Poisson}(\mu g)} and
\eqn{X_2 \mid G = g \sim \text{Poisson}(r \mu g)} where
\eqn{G \sim \text{Gamma}(\theta, \theta^{-1})} is the random item (subject)
effect. Then \eqn{X_1, X_2 \sim \text{BNB}(\mu, r, \theta)} is the joint
distribution where \eqn{X_1} and \eqn{X_2} are dependent (though conditionally
independent), \eqn{X_1} is the count outcome for sample 1 of the items
(subjects), \eqn{X_2} is the count outcome for sample 2 of the items (subjects),
\eqn{\mu} is the conditional mean of sample 1, \eqn{r} is the ratio of the
conditional means of sample 2 with respect to sample 1, and \eqn{\theta} is
the gamma distribution shape parameter which controls the dispersion and the
correlation between sample 1 and 2.

The hypotheses for the Wald test of \eqn{r} are

\deqn{
\begin{aligned}
H_{null} &: f(r) = f(r_{null}) \\
H_{alt} &: f(r) \neq f(r_{null})
\end{aligned}
}

where \eqn{f(\cdot)} is a one-to-one link function with nonzero derivative,
\eqn{r = \frac{\bar{X}_2}{\bar{X}_1}} is the population ratio of arithmetic
means for sample 2 with respect to sample 1, and \eqn{r_{null}} is a constant
for the assumed null population ratio of means (typically \eqn{r_{null} = 1}).

\insertCite{rettiganti_2012;textual}{depower} found that \eqn{f(r) = r^2},
\eqn{f(r) = r}, and \eqn{f(r) = r^{0.5}} had greatest power when \eqn{r < 1}.
However, when \eqn{r > 1}, \eqn{f(r) = \ln r}, the likelihood ratio test, and
\eqn{f(r) = r^{0.5}} had greatest power. \eqn{f(r) = r^2} was biased when
\eqn{r > 1}. Both \eqn{f(r) = \ln r} and \eqn{f(r) = r^{0.5}} produced
acceptable results for any \eqn{r} value. These results depend on the use of
asymptotic vs. exact critical values.

The Wald test statistic is

\deqn{
W(f(\hat{r})) = \left( \frac{f \left( \frac{\bar{x}_2}{\bar{x}_1} \right) - f(r_{null})}{f^{\prime}(\hat{r}) \hat{\sigma}_{\hat{r}}} \right)^2
}

where

\deqn{
\hat{\sigma}^{2}_{\hat{r}} = \frac{\hat{r} (1 + \hat{r}) (\hat{\mu} + \hat{r}\hat{\mu} + \hat{\theta})}{n \left[ \hat{\mu} (1 + \hat{r}) (\hat{\mu} + \hat{\theta}) - \hat{\theta}\hat{r} \right]}
}

Under \eqn{H_{null}}, the Wald test statistic is asymptotically distributed
as \eqn{\chi^2_1}. The approximate level \eqn{\alpha} test rejects
\eqn{H_{null}} if \eqn{W(f(\hat{r})) \geq \chi^2_1(1 - \alpha)}. Note that
the asymptotic critical value is known to underestimate the exact critical
value. Hence, the nominal significance level may not be achieved for small
sample sizes (possibly \eqn{n \leq 10} or \eqn{n \leq 50}). The level of
significance inflation also depends on \eqn{f(\cdot)} and is most severe for
\eqn{f(r) = r^2}, where only the exact critical value is recommended.
}
\examples{
#----------------------------------------------------------------------------
# wald_test_bnb() examples
#----------------------------------------------------------------------------
library(depower)

set.seed(1234)
sim_bnb(
  n = 40,
  mean1 = 10,
  ratio = 1.2,
  dispersion = 2
) |>
  wald_test_bnb()

}
\references{
\insertRef{rettiganti_2012}{depower}

\insertRef{aban_2009}{depower}
}
