% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.depower}
\alias{plot.depower}
\title{Plot power objects}
\usage{
\method{plot}{depower}(
  x,
  x_axis = NULL,
  y_axis = NULL,
  color = NULL,
  facet_row = NULL,
  facet_col = NULL,
  hline = NULL,
  caption = TRUE,
  caption_width = 70L,
  ...
)
}
\arguments{
\item{x}{(depower)\cr
The data frame returned by \code{\link[=power]{power()}}.}

\item{x_axis}{(string: \code{NULL}; \code{names(x)})\cr
The name of the column to be used for the x-axis. Automatically chosen
if \code{NULL}.}

\item{y_axis}{(string: \code{NULL}; \code{names(x)})\cr
The name of the column to be used for the y-axis. Automatically chosen
if \code{NULL}. Generally, \code{"power"} (default) should be used for the y-axis.}

\item{color}{(string: \code{NULL}; \code{names(x)})\cr
The name of the column to be used for the \code{\link[ggplot2:aes]{ggplot2::aes()}} color
aesthetic. Automatically chosen if \code{NULL}. Use \code{NA} to turn off.}

\item{facet_row}{(string: \code{NULL}; \code{names(x)})\cr
The name of the column to be used for the \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} row.
Automatically chosen if \code{NULL}. Use \code{NA} to turn off.}

\item{facet_col}{(string: \code{NULL}; \code{names(x)})\cr
The name of the column to be used for the \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}}
column. Automatically chosen if \code{NULL}. Use \code{NA} to turn off.}

\item{hline}{(numeric: \code{NULL}; \verb{(0, 1)})\cr
The y-intercept at which to draw a horizontal line.}

\item{caption}{(Scalar logical: \code{TRUE})\cr
If \code{TRUE} (default), a caption is added to the plot. The caption
includes information on parameter values that were conditioned on to
generate the plot. If \code{FALSE}, the caption is not included.}

\item{caption_width}{(Scalar integer: \code{70L})\cr
The target column number for wrapping the caption text.}

\item{...}{Unused additional arguments.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
An automatic plot method for objects returned by \code{\link[=power]{power()}}.
}
\details{
If you are limited by the output from \code{plot.depower()}, keep in mind that the
object returned by \code{\link[=power]{power()}} is a standard data frame. This allows
you to easily plot all results with standard plotting functions. In addition,
because \code{plot.depower()} uses ggplot2, you can modify the plot as you
normally would. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{set.seed(1234)
sim_log_lognormal(
  n1 = c(10, 15),
  n2 = c(10, 15),
  ratio = c(1.3, 1.5),
  cv1 = c(0.3),
  cv2 = c(0.3, 0.5),
  nsims = 1000
) |>
  power(alpha = 0.05) |>
  plot(hline = 0.8, caption_width = 60) +
  ggplot2::theme_bw() +
  ggplot2::theme(plot.caption = ggplot2::element_text(hjust = 0)) +
  ggplot2::labs(title = "Power for the ratio of geometric means")
}\if{html}{\out{</div>}}

\if{html}{\out{<div style="display: flex; justify-content: center; padding-top: 10px; padding-bottom: 10px;">
  <img style="max-width: 100\%; height: auto;" src="figures/plot_details-1.svg" alt="Example of extending plot() with ggplot2 functions" />
</div>}}
\if{latex}{
  \out{\begin{center}}
  \figure{plot_details-1.pdf}{options: width=4in}
  \out{\end{center}}
}
}
\examples{
#----------------------------------------------------------------------------
# plot() examples
#----------------------------------------------------------------------------
library(depower)

# Power for independent two-sample t-test
set.seed(1234)
sim_log_lognormal(
  n1 = c(10, 15),
  n2 = c(10, 15),
  ratio = c(1.3, 1.5),
  cv1 = c(0.3),
  cv2 = c(0.3, 0.5),
  nsims = 500
) |>
  power(alpha = 0.05) |>
  plot()

# Power for dependent two-sample t-test
set.seed(1234)
sim_log_lognormal(
  n1 = c(10, 15),
  n2 = c(10, 15),
  ratio = c(1.3, 1.5),
  cv1 = c(0.3, 0.5),
  cv2 = c(0.3, 0.5),
  cor = c(0.3),
  nsims = 500
) |>
  power(alpha = 0.01) |>
  plot()

# Power for two-sample independent AND two-sample dependent t-test
set.seed(1234)
sim_log_lognormal(
  n1 = c(10, 15),
  n2 = c(10, 15),
  ratio = c(1.3, 1.5),
  cv1 = c(0.3),
  cv2 = c(0.3),
  cor = c(0, 0.3, 0.6),
  nsims = 500
) |>
  power(alpha = c(0.05, 0.01)) |>
  plot(facet_row = "cor", color = "test")

# Power for one-sample t-test
set.seed(1234)
sim_log_lognormal(
  n1 = c(10, 15),
  ratio = c(1.2, 1.4),
  cv1 = c(0.3, 0.5),
  nsims = 500
) |>
  power(alpha = c(0.05, 0.01)) |>
  plot()

\donttest{
# Power for independent two-sample NB test
set.seed(1234)
sim_nb(
  n1 = c(10, 15),
  mean1 = 10,
  ratio = c(1.8, 2),
  dispersion1 = 10,
  dispersion2 = 3,
  nsims = 100
) |>
  power(alpha = 0.01) |>
  plot()

# Power for BNB test
set.seed(1234)
sim_bnb(
  n = c(10, 12),
  mean1 = 10,
  ratio = c(1.3, 1.5),
  dispersion = 5,
  nsims = 100
) |>
  power(alpha = 0.01) |>
  plot()
}

}
\seealso{
\code{\link[=power]{power()}}
}
