% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_univariate}
\alias{plot_univariate}
\title{Scatter plot of density ratios and individual variables}
\usage{
plot_univariate(
  x,
  vars = NULL,
  samples = "both",
  logscale = TRUE,
  grid = FALSE,
  sample.facet = FALSE,
  nrow.panel = NULL,
  tol = 0.01,
  ...
)
}
\arguments{
\item{x}{Density ratio object created with e.g., \code{\link[=kliep]{kliep()}}, \code{\link[=ulsif]{ulsif()}},
or \code{\link[=naive]{naive()}}}

\item{vars}{Character vector of variable names to be plotted.}

\item{samples}{Character string indicating whether to plot the 'numerator',
'denominator', or 'both' samples. Default is 'both'.}

\item{logscale}{Logical indicating whether to plot the density ratio
estimates on a log scale. Default is TRUE.}

\item{grid}{Logical indicating whether output should be a list of individual plots ("individual"), or one facetted plot with all variables ("assembled"). Defaults to "individual".}

\item{sample.facet}{Logical indicating whether to facet the plot by sample, i.e, showing plots separate for each sample, and side to side. Defaults to FALSE.}

\item{nrow.panel}{Integer indicating the number of rows in the assembled plot. If NULL, the number of rows is automatically calculated.}

\item{tol}{Numeric indicating the tolerance: values below this value will be set to the tolerance value, for legibility of the plots}

\item{...}{Additional arguments passed to the predict() function.}
}
\value{
Scatter plot of density ratios and individual variables.
}
\description{
A scatter plot showing the relationship between estimated density ratios and individual variables.
}
\examples{
set.seed(123)
# Fit model
dr <- ulsif(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
ulsif(numerator_small, denominator_small, sigma = 2, lambda = 2)
}
