% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dams-package.R
\docType{data}
\name{nid_all}
\alias{nid_all}
\title{Dams information from the NID database}
\description{
\tabular{ll}{
dam_name              \tab Dam Name (Alphanumeric) The official name of the dam. No abbreviations unless the abbreviation is a part of the official name. For dams that do not have an official name, the popular name is used                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  \cr
other_dam_name        \tab Other Dam Names (Alphanumeric) Names other than the official name (i.e., reservoir name) of the dam in common use. Names are separated using a semi-colon. Blank if not applicable                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
dam_former_name       \tab Dam Former Name (Alphanumeric) Previous reservoir or dam name(s), if changed. Names are separated using a semi-colon                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
state_reg_agency      \tab State or Federal Agency ID (Alphanumeric) The Official State or Agency identification number for the dam                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             \cr
nidid                 \tab NID ID (Alphanumeric) The official NID identification number for the dam, known formerly as the National ID. This is a required field, and must have an entry for each dam included in the NID. This field is used as the unique identifier for each dam record. The first two characters of the identity are the state two-letter abbreviation, based on the location of the dam. Typically, the last five characters of the identity are a unique number (AB#####); although States are allowed to use alphanumeric combinations in these last five characters. For saddle dams or dikes, the NID ID is the same as the main dam. See saddle dam definition in Number Separate Structures Field (listed below)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     \cr
numseparatestructures \tab Number Separate Structures (Number) Number of separate structures associated with this dam project. Include saddle dams (or dikes) as defined in FEMA 148: Federal Guidelines for Dam Safety, Glossary of Terms, as a subsidiary dam of any type constructed across a saddle or low point on the perimeter of a reservoir. Not included in the number of appurtenant works which include, but are not limited to, such structures as spillways, either in the dam or separate there from; the reservoir and its rim; low level outlet works; and water conduits such as tunnels, pipelines or penstocks, either through the dam or its abutments (FEMA Model State Dam Safety Program Glossary of Terms)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             \cr
otherstructureid      \tab Other Structure ID (Alphanumeric) The identification number (S001, S002, etc.) for the saddle dam or dike associated with the larger dam project. This field only applies to saddle dams or dikes. This field is blank for all other dams                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            \cr
longitude             \tab Longitude (Number) Longitude at dam centerline as a single value in decimal degrees, NAD83.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          \cr
latitude              \tab Latitude (Number) Latitude at dam centerline as a single value in decimal degrees, NAD83.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            \cr
section               \tab Section, Township, Range Location (Alphanumeric) Optional field. The information is in any form that is understandable and that clearly designates the individual values, i.e. S21, 73N, R69W. If the prime meridian location is needed to locate the dam within the state, include it in the field, i.e. S21, T3N, R68W of 6PM (Sixth Prime Meridian).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              \cr
county                \tab County (Alphanumeric) The name of the county in which the dam is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            \cr
river                 \tab River or Stream (Alphanumeric) The River or Stream designation may be entered in one of two ways. For the convenience of some organizations, an alternative field entry is provided which is consistent with the “tributary and offstream” designations used in the 1995-96 NID. If the alternative form is used, the NID Data Team will convert it to the standard form prior to inclusion in the national inventory. River or Stream Standard Entry: The official name of the river or stream on which the dam is built. If the stream is unnamed, identify it as a tributary to a named river, e.g., Snake-TR. If the dam is located offstream, enter the name of the river or stream plus “-OS”, e.g., Snake-OS. River or Stream Alternative Entry: The official name of the river or stream on which the dam is built. If the stream is unnamed, identify it as a tributary to a named river, e.g., TR- Snake. If the darn is located offstream, enter the name of the river or stream plus the word, “OFFSTREAM,” e.g., Snake OFFSTREAM.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       \cr
city                  \tab Nearest Downstream City/Town (Alphanumeric) Name of the nearest downstream city, town, or village that is most likely to be affected by floods resulting from the failure of the dam.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                \cr
distance              \tab Distance to Nearest City/Town (Miles, Number) Distance from the dam to the nearest affected downstream city/town/village (listed in the previous field), to the nearest mile (and tenth if appropriate).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             \cr
owner_name            \tab Owner Name (Alphanumeric) Name(s) of the dam owner. If multiple owners, different owners are separated by a semi- colon.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             \cr
owner_type            \tab Owner Type (Alphanumeric) Code to indicate the type of owner: F for Federal; S for State; L for Local Government (defined as have taxing authority or is supported by taxes); U for Public Utility; P for Private X for Not Listed. Codes are concatenated if the dam is owned by more than one type. For example, if the dam is owned by a lake association and a public utility, the owner type would be listed as                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
dam_designer          \tab Dam Designer (Alphanumeric) Name of the principal firm(s) or agency accomplishing design of dam and major appurtenant operating features, and major modifications. Original designer is listed first, then modification designers (if applicable). The names are separated using a semi-colon. If an Architect-Engineer Firm designed the dam under a state or federal government contract, the state or federal agency name is listed first; then the company name second separated by a semi-colon.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                \cr
dam_type              \tab Dam Type (Alphanumeric) Codes, in order of importance, to indicate the type of dam: RE for Earth; ER for Rockfill; PG for Gravity; CB for Buttress; VA for Arch; MV for Multi-Arch; RC for Roller-Compacted Concrete; CN for Concrete; MS for Masonry; ST for Stone; TC for Timber Crib; OT for Other. Codes are concatenated if the dam is a combination of several types. For example, the entry CNCB would indicate a concrete buttress dam type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
core                  \tab Core (Alphanumeric) Code to indicate the position, type of watertight member and certainty, Position: F for upstream facing; H for homogeneous dam; I for core; X for unlisted/unknown; Type: A for bituminous concrete; C for concrete; E for earth; M for metal; P for plastic;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    \cr
foundation            \tab Foundation (Alphanumeric) Code for the material upon which dam is founded, and certainty: Foundation: R for rock; RS for rock and soil; S for soil; U for unlisted/unknown. Certainty: K for known; Z for estimated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
purposes              \tab Purposes (Alphanumeric) Code(s) to indicate the current purpose(s) for which the reservoir is used: I for Irrigation; H for Hydroelectric; C for Flood Control and Storm Water Management; N for Navigation; S for Water Supply; R for Recreation; P for Fire Protection, Stock, Or Small Farm Pond; F for Fish and Wildlife Pond; D for Debris Control; T for Tailings; G for Grade Stabilization; O for Other. The order should indicate the relative decreasing importance of the purpose. Codes are concatenated if the dam has multiple current purposes. For example, SCR would indicate the primary purposes, Water Supply, followed by Flood Control and Storm Water Management, and then Recreation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \cr
year_completed        \tab Year Completed (Number) Year (four digits) when the original main dam structure was completed. If unknown, and reasonable estimate is unavailable, “0000” is used.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
year_modified         \tab Year Modified (Alphanumeric) Year (four digits) when major modifications or rehabilitation of dam or major control structures were completed. Major modifications are defined as a structural, foundation, or mechanical construction activity which significantly restores the project to original condition; changes the project’s operation; capacity or structural characteristics (e.g. spillway or seismic modification); or increases the longevity, stability, or safety of the dam and appurtenant structures. Entries should be followed by one of more of the following codes indicating type of modification: S for structural; F for foundation; M for mechanical; E for seismic;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       \cr
dam_length            \tab Dam Length (Feet, Number) Length of the dam, in feet, which is defined as the length along the top of the dam. This also includes the spillway, powerplant, navigation lock, fish pass, etc., where these form part of the length of the dam. If detached from the dam, these structures should not be included.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     \cr
dam_height            \tab Dam Height (Feet, Number) Height of the dam, in feet to the nearest foot , which is defined as the vertical distance between the lowest point on the crest of the dam and the lowest point in the original streambed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                \cr
structural_height     \tab Structural Height (Feet, Number) Structural height of the dam, in feet to the nearest foot, which is defined as the vertical distance from the lowest point of the excavated foundation to the top of the dam. Top of dam refers to the parapet wall and not the crest.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              \cr
hydraulic_height      \tab Hydraulic Height (Feet, Number) Hydraulic height of the dam, in feet to the nearest foot , which is defined as the vertical difference between the maximum design water level and the lowest point in the original streambed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \cr
nid_height            \tab NID Height (Feet, Number) Calculated field: Maximum value of dam height, structural height, and hydraulic height. Accepted as the general height of the dam.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         \cr
max_discharge         \tab Maximum Discharge (Cubic Feet/Second, Number) Number of cubic feet per second (cu ft/sec) which the spillway is capable of discharging when the reservoir is at its maximum designed water surface elevation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \cr
max_storage           \tab Maximum Storage (Acre-Feet, Number) Maximum storage, in acre-feet, which is defined as the total storage space in a reservoir below the maximum attainable water surface elevation, including any surcharge storage.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
normal_storage        \tab Normal Storage (Acre-Feet, Number) Normal storage, in acre-feet, which is defined as the total storage space in a reservoir below the normal retention level, including dead and inactive storage and excluding any flood control or surcharge storage. For normally dry flood control dams, the normal storage will be a zero value. If unknown, the value will be blank and not zero.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              \cr
nid_storage           \tab NID Storage (Acre-Feet, Number) Calculated field: Maximum value of normal storage and maximum storage. Accepted as the general storage of the dam.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
surface_area          \tab Surface Area (Acres, Number) Surface area, in acres, of the impoundment at its normal retention level.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               \cr
drainage_area         \tab Drainage Area (Square Miles, Number) Drainage area of the dam, in square miles, which is defined as the area that drains to a particular point (in this case, the dam) on a river or stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         \cr
hazard                \tab Downstream Hazard Potential (Alphanumeric) Code to indicate the potential hazard to the downstream area resulting from failure or mis- operation of the dam or facilities: L for Low; S for Significant; H for High U for Undetermined. Definitions, as accepted by the Interagency Committee on Dam Safety, are as follows: 1. LOW HAZARD POTENTIAL Dams assigned the low hazard potential classification are those where failure or mis- operation results in no probable loss of human life and low economic and/or environmental losses. Losses are principally limited to the owner’s property. 2. SIGNIFICANT HAZARD POTENTIAL Dams assigned the significant hazard potential classification are those dams where failure or mis-operation results in no probable loss of human life but can cause economic loss, environment damage, disruption of lifeline facilities, or impact other concerns. Significant hazard potential classification dams are often located in predominantly rural or agricultural areas but could be located in areas with population and significant infrastructure. 3. HIGH HAZARD POTENTIAL Dams assigned the high hazard potential classification are those where failure or mis- operation will probably cause loss of human life. Hazard Potential Loss of Human Life Economic, Environmental, Lifeline Losses Classification Low None expected Low and generally limited to owner Significant None expected Yes High Probable. One or more Yes (but not necessary for this expected classification) 4. UNDETERMINED HAZARD POTENTIAL Dams for which a downstream hazard potential, as defined in 1-3 above, has not been designated or is not provided. Note that dams with a code “U” will be considered for NID inclusion the same as a dam with low hazard potential. If included in the NID, the undetermined classification will be used in publication.\cr
enforcementauthority  \tab Emergency Action Plan (Alphanumeric) Code indicating whether this dam has an Emergency Action Plan (EAP) developed by the dam owner. An EAP is defined as a plan of action to be taken to reduce the potential for property damage and loss of life in an area affected by a dam failure or large flood. Y for Yes; N for No; NR for Not Required by submitting agency. If an EAP is required (or not required) and has one, it will be listed Y for Yes. If an EAP is required and does not have one, it will be listed N for No. If there is not an EAP and one is not required, it will be listed NR for Not Required.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            \cr
dam_name              \tab Date of Last Revision of Emergency Action Plan (Date) Date of the most recent revision of the Emergency Action Plan prior to the transmittal of the data by the submitting agency.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
inspection_date       \tab Inspection Date (Number) Date of the most recent inspection of the dam prior to the transmittal of the data by the submitting agency.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                \cr
inspection_frequency  \tab Inspection Frequency (Number) The scheduled frequency interval for periodic inspections, in years.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
cong_name             \tab Condition Assessment (Alphanumeric) Assessment that best describes the condition of the dam based on available information. Satisfactory; Fair; Poor; Unsatisfactory; Not Rated. Definitions, as accepted by the National Dam Safety Review Board, are as follows: 1. SATISFACTORY No existing or potential dam safety deficiencies are recognized. Acceptable performance is expected under all loading conditions (static, hydrologic, seismic) in accordance with the applicable regulatory criteria or tolerable risk guidelines. 2. FAIR No existing dam safety deficiencies are recognized for normal loading conditions. Rare or extreme hydrologic and/or seismic events may result in a dam safety deficiency. Risk may be in the range to take further action. 3. POOR A dam safety deficiency is recognized for loading conditions which may realistically occur. Remedial action is necessary. POOR may also be used when uncertainties exist as to critical analysis parameters which identify a potential dam safety deficiency. Further investigations and studies are necessary.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     \cr
cong_name             \tab Condition Assessment Detail (Alphanumeric) The specific detail that best describes the reason for the condition assessment. This field only applies to dams that were assigned the condition Satisfactory, Poor or Not Rated. If a dam was rated Unsatisfactory or Fair, this field will be left blank. 1. Satisfactory • Meets applicable hydrologic and seismic regulatory criteria • Meets applicable tolerable risk criteria 2. Poor • Deficiency Recognized • More Analysis Needed 3. Not Rated • Dam has not been inspected • Not under state jurisdiction • Other                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             \cr
cong_name             \tab Condition Assessment Date (Number) Date of the most recent assessment of the dam prior to the transmittal of the data by the submitting agency.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      \cr
spillway_type         \tab Spillway Type (Alphanumeric) Code that describes the type of spillway: C for Controlled; U for Uncontrolled; N for None.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             \cr
spillway_width        \tab Spillway Width (Number) The width of the spillway, to the nearest foot, available for discharge when the reservoir is at its maximum designed water surface elevation. Typically for an open channel spillway, this is the bottom width. For pipe spillways or drop inlets that have diameters, use the diameter of the pipe.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \cr
outlet_gates          \tab Outlet Gates (Alphanumeric) Code(s) that describe the type of (1) spillway and (2) controlled outlet gates, if any: X for None; U for Uncontrolled; T for Tainter (radial);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          \cr
volume                \tab Volume of Dam (Cubic yards, Number) Total number of cubic yards occupied by the materials used in the dam structure. Portions of powerhouse, locks, and spillways are included only if they are an integral part of the dam and required for structural stability.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
number_of_locks       \tab Number of Locks (Number) Number of existing navigation locks for the project.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \cr
length_of_locks       \tab Length of Locks (Feet, Number) Length of the primary navigation lock to the nearest foot.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            \cr
width_of_locks        \tab Lock Width (Number) Width of the primary navigation lock to the nearest foot.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        \cr
permittingauthority   \tab Permitting Authority (Alphanumeric) Yes if the state regulatory organization has the authority to review and approve plans and specifications to construct, enlarge, remove, and abandon dams (from the National Dam Safety Program Act of 2014).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    \cr
inspectionauthority   \tab Inspection Authority (Alphanumeric) Yes if the state regulatory organization has the authority to require or perform the inspection, at least once every five years, of all dams and reservoirs that would pose a significant threat to human life and property in case of failure to determine the continued safety of the dams and reservoirs (from the National Dam Safety Program Act of 2014) .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
enforcementauthority  \tab Enforcement Authority (Alphanumeric) Yes if the state regulatory organization has the authority to issue notices, when applicable, to require owners of dams to perform necessary maintenance or remedial work, revise operating procedures, or take other actions, including breaching dams when necessary (from the National Dam Safety Program Act of 2014).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      \cr
state_reg_dam         \tab State Jurisdictional Dam (Alphanumeric) Yes if this dam meets the state regulatory organization’s definition of a jurisdictional dam. For example, in New Mexico a jurisdictional dam is defined as a dam that exceeds 10 feet in height regardless of storage or a dam that stores more than 10 acre-feet regardless of height. Therefore, in New Mexico, all dams that meet that state criteria will have Yes listed in this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                \cr
state_reg_dam         \tab State Regulated Dam (Alphanumeric) Calculated field: based on Permitting Authority, Inspection Authority and Enforcement Authority. If Yes to all three authority criteria, then dam is state regulated and will be listed as Yes.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
state_reg_agency      \tab State Regulatory Agency (Alphanumeric) Name of the primary state agency with regulatory or approval authority over the dam.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          \cr
fed_funding           \tab Federal Agency Involvement in Funding (Alphanumeric) Code identifying which federal agency was involved in funding of the dam. Codes are separated by semi-colon if several agencies were involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  \cr
fed_construction      \tab Federal Agency Involvement in Construction (Alphanumeric) Code identifying which federal agency was involved in the construction of the dam. Codes are separated by semi-colon if several agencies were involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    \cr
fed_regulatory        \tab Federal Agency Involvement in Regulatory (Alphanumeric) Code identifying which federal agency is involved in the regulation of the dam. Codes are separated by semi-colon if several agencies are involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          \cr
fed_inspection        \tab Federal Agency Involvement in Inspection (Alphanumeric) Code identifying which federal agency is involved in the inspection of the dam. Codes are separated by semi-colon if several agencies are involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          \cr
fed_operation         \tab Federal Agency Involvement in Operation (Alphanumeric) Code identifying which federal agency is involved in the operation of the dam. Codes are separated by semi-colon if several agencies are involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            \cr
fed_owner             \tab Federal Agency Owner (Alphanumeric) Code identifying which federal agency partly or wholly owns the dam. Codes are separated by semi-colon if several owners are involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           \cr
fed_regulatory        \tab Federal Agency Involvement – Other (Alphanumeric) Code identifying which federal agency is involved in other aspects of the dam. Codes are separated by semi-colon if several owners are involved.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \cr
source_agency         \tab Source Agency (Alphanumeric) Calculated Field: Primary state or federal agency responsible for data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 \cr
state                 \tab State (Alphanumeric) State where dam is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     \cr
submit_date           \tab Submit Date (Date) Calculated Field: Date data was submitted to the US Army Corps of Engineers for inclusion to the National Inventory of Dams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      \cr
url_address           \tab URL Address (Alphanumeric) Web Site for more information on particular dam. This information is not collected at this time and represents a placeholder for future data collection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  \cr
cong_dist             \tab Congressional Representative District (Alphanumeric) Calculated Field: Congressional District where dam is located. Congressional District is generated based on provided coordinates. If no coordinates are provided, then this field will be left blank.
}
}
\references{
NID: The National Inventory of Dams Data Dictionary from the
United States Army Corps of Engineers, descriptions extracted from \url{https://nid.sec.usace.army.mil/ords/NID_R.downloadFile?InFileName=NID_DataDictionary.pdf}
in May 2020.
}
\seealso{
\link{nid_subset}
}
\keyword{datasets}
