% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrarray.R
\name{corrarray}
\alias{corrarray}
\title{Correlation Arrays and 2-Sample Correlation Matrices}
\usage{
corrarray(x, group = NULL, lower = NULL, upper = NULL,
  output = c("matrix", "array", "sig.matrix", "sig.array"),
  use = c("complete.obs", "everything", "all.obs",
  "na.or.complete", "pairwise.complete.obs"),
  method = c("pearson", "kendall", "spearman"))
}
\arguments{
\item{x}{a matrix or data frame. Variables can be quantitative or categorical.}

\item{group}{the grouping variable name. If no group is specified (default),
then a single correlation matrix for the entire sample will be generated.}

\item{lower}{the level of the grouping variable to be placed in the
lower triangular matrix. If no level is specified (default), then
the first level in the data set is treated as the lower level.}

\item{upper}{the level of the grouping variable to be placed in the
upper triangular matrix. If no level is specified (default), then
the second level in the data set is treated as the lower level.}

\item{output}{If a group that has 2 or more levels is specified,
then "\code{matrix}" (default) returns the corresponding 2-sample
correlation matrix, and "\code{array}" returns the
correlation array. "\code{sig.matrix}" and "\code{sig.array}" return
the significance values of the corresponding correlations.}

\item{use}{an optional character string giving a method for
computing correlations in the presence of missing values.
This must be one of the strings "\code{complete.obs}" (default),
"\code{everything}", "\code{all.obs}", "\code{na.or.complete}",
or "\code{pairwise.complete.obs}".
The default option removes rows with missing values from calculations.}

\item{method}{a character string indicating which correlation coefficient
is to be computed: "\code{pearson}" (default), "\code{kendall}",
or "\code{spearman}".}
}
\value{
\code{corrarray} returns an array or matrix of correlations
  as numeric values from \code{-1} to \code{1} (inclusive),
  or of significance values of the corresponding correlations,
  and with row and column names as the variable names.
}
\description{
This function creates a multi-sample correlation array
  combining the correlation matrices for each level of the specified
  grouping variable.
  Given two levels of the grouping variable, this function creates a single
  correlation matrix displaying the individual triangular matrices on
  opposite sides of the principal diagonal.
}
\details{
If multiple values are provided for \code{group},
  \code{lower}, or \code{upper}, then only the first value is used.
  Apart from the grouping variable, all other variables whose values are
  not numeric are removed from the correlation matrices. The grouping
  variable's values, even if numeric, are automatically treated as
  different levels.
}
\examples{
## All observations: 1-sample correlation matrix.
corrarray(iris)

## Stratify by the three species: 3-sample correlation array.
corrarray(iris, "Species", output = "array")

## Specify lower and upper samples: 2-sample correlation matrix.
corrarray(iris, "Species", lower = "setosa", upper = "virginica")

}
\seealso{
\code{\link{cor}} for further descriptions of the \code{use}
  and \code{method} parameters, and \code{\link{rcorr}} for significance
  tests of correlations.
}
