% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_record.R
\name{cong_bound_record}
\alias{cong_bound_record}
\title{Request bound Congressional Record Information}
\usage{
cong_bound_record(
  year = NULL,
  month = NULL,
  day = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{year}{integer for year}

\item{month}{integer for month}

\item{day}{integer for day of month}

\item{limit}{number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{xml} or \code{json}.}

\item{clean}{Default is TRUE. Should output be returned as a \code{tibble} (\code{TRUE}) or requested \code{format}.}
}
\value{
\code{tibble} or HTTP response if \code{clean = FALSE}
}
\description{
Request bound Congressional Record Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Requires API Key

cong_bound_record()

cong_bound_record(year = 1990)

cong_bound_record(year = 1990, month = 5)

cong_bound_record(year = 1948, month = 5, day = 19)
\dontshow{\}) # examplesIf}
}
