% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarkovChain.r
\docType{class}
\name{MarkovChain-class}
\alias{MarkovChain-class}
\title{Class \code{MarkovChain}}
\description{
Class \code{MarkovChain}
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("MarkovChain", ...)}. This S4 class describes \code{MarkovChain} objects.
}

\examples{

# show MarkovChain definition
showClass("MarkovChain")

# fit a simple Markov chain from a list of click streams
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
cls <- as.clickstreams(clickstreams, header = TRUE)
mc <- fitMarkovChain(cls)
show(mc)

}
\seealso{
\code{\link{fitMarkovChain}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{classes}
