% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability.R
\name{probability}
\alias{probability}
\alias{format.probability}
\alias{print.probability}
\title{Symbolic Probability Distributions}
\usage{
probability(val = NULL, var = NULL, do = NULL, cond = NULL)

\method{format}{probability}(x, use_do = FALSE, ...)

\method{print}{probability}(x, ...)
}
\arguments{
\item{val}{An \code{integer} value of either 0 or 1 for almost sure events.}

\item{var}{A \code{list} of objects of class \code{counterfactual_variable}
(without interventions and with value assignments).
\code{var} defines the observations \eqn{y} in \eqn{P(y|do(x),z)}.}

\item{do}{A \code{list} of \code{counterfactual_variable} variable objects
(without interventions and with value assignments). Defines the
intervention set \eqn{x} in \eqn{P(y|do(x),z)}.}

\item{cond}{A \code{list} of \code{counterfactual_variable} variable objects
(without interventions and with value assignments).Defines the
conditioning set \eqn{z} in \eqn{P(y|do(x),z)}.}

\item{x}{A \code{probability} object.}

\item{use_do}{A \code{logical} value. If \code{TRUE}, the explicit do-operation is
used to denote interventional probabilities (e.g., \eqn{P(y|do(x))}).
If \code{FALSE} (the default), the subscript notation is used instead
(e.g., \eqn{P_x(y)}).}

\item{...}{Additional arguments passed to \code{format}.}
}
\value{
An object of class \code{probability}, which is a \code{list} containing
all of the arguments of the constructor.

A \code{character} representation of the \code{probability} object
in LaTeX syntax.
}
\description{
Defines an interventional or observational (conditional) probability
\eqn{P(y|do(x),z)}. For formatting options, see \code{\link[=format.probability]{format.probability()}}.
}
\examples{
# Example from Makhlouf, Zhioua and Palamidessi (2021)
g2 <- dag("C -> A -> Y; C -> Y")
v1 <- cf("Y", 0, c(A = 1))
v2 <- cf("A", 0)
c1 <- conj(v1)
c2 <- conj(v2)
f <- identifiable(g2, c1, c2)$formula

# Default, using primes and subscript notation
format(f)

# Without primes, no do-operator
format(f, use_primes = FALSE)

# Primes, with do-operator
format(f, use_do = TRUE)

# Without primes, with do-operator
format(f, use_primes = FALSE, use_do = TRUE)

}
\seealso{
\code{\link[=counterfactual_variable]{counterfactual_variable()}}, \code{\link[=functional]{functional()}}
}
