% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{find_hugo}
\alias{find_hugo}
\alias{remove_hugo}
\title{Find or remove the Hugo executable}
\usage{
find_hugo(version = getOption("blogdown.hugo.version"), quiet = FALSE)

remove_hugo(version = getOption("blogdown.hugo.version"), force = FALSE)
}
\arguments{
\item{version}{The expected version number, e.g., \code{'0.25.1'}. If
\code{NULL}, it will try to find/remove the maximum possible version. If
\code{'all'}, find/remove all possible versions. In an interactive R
session when \code{version} is not provided, \code{remove_hugo()} will list
all installed versions of Hugo, and you can select which versions to
remove.}

\item{quiet}{Whether to signal a message when two versions of Hugo are found:
one is found on the system \var{PATH} variable, and one is installed by
\code{\link{install_hugo}()}.}

\item{force}{By default, \code{remove_hugo()} only removes Hugo installed via
\code{\link{install_hugo}()}. For \code{force = TRUE}, it will try to
remove any Hugo executables found via \code{find_hugo()}.}
}
\value{
For \code{find_hugo()}, it returns the path to the Hugo executable if
  found, otherwise it will signal an error, with a hint on how to install
  (the required version of) Hugo. If Hugo is found via the environment
  variable \var{PATH}, only the base name of the path is returned (you may
  use \code{\link{Sys.which}('hugo')} to obtain the full path).

  If \code{version = 'all'}, return the paths of all versions of Hugo
  installed.
}
\description{
Search for Hugo in a series of possible installation directories (see
\code{\link{install_hugo}()} for these directories) with \code{find_hugo()},
or remove the Hugo executable(s) found with \code{remove_hugo()}.
}
\details{
If your website depends on a specific version of Hugo, we strongly recommend
that you set \code{options(blogdown.hugo.version = )} to the version number
you desire in the file \code{.Rprofile} in the root directory of the website
project, so that \pkg{blogdown} can try to find the right version of Hugo
before it builds or serves the website. You can use the function
\code{\link{config_Rprofile}()} to do this automatically.
}
