% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobians.R
\name{jac.invlogit}
\alias{jac.invlogit}
\title{Jacobian for logit transform}
\usage{
jac.invlogit(x, log = TRUE)
}
\arguments{
\item{x}{value at which to evaluate \eqn{J(x)}}

\item{log}{TRUE to return \eqn{log(J(x))}}
}
\description{
Let \eqn{X=logit^{-1}(Y)} be a transformation of a random variable \eqn{Y}.  
This function computes the jacobian \eqn{J(x)} when using the density of 
\eqn{Y} to evaluate the density of \eqn{X} via
\deqn{f(x) = f_y(logit(x)) J(x)}
where 
\deqn{J(x) = d/dx logit(x).}
}
\examples{
jac.invlogit(1)

}
