% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_onset.R
\name{seasonal_onset}
\alias{seasonal_onset}
\title{Automated and Early Detection of Seasonal Epidemic Onset}
\usage{
seasonal_onset(
  tsd,
  k = 5,
  level = 0.95,
  disease_threshold = NA_integer_,
  family = c("poisson", "quasipoisson"),
  na_fraction_allowed = 0.4,
  season_start = NULL,
  season_end = season_start - 1,
  only_current_season = NULL
)
}
\arguments{
\item{tsd}{An object containing time series data with 'time' and 'observation.'}

\item{k}{An integer specifying the window size for modeling growth rates for the onset.}

\item{level}{The confidence level for onset parameter estimates, a numeric value between 0 and 1.}

\item{disease_threshold}{An integer specifying the threshold for considering a disease outbreak. It defines the per time-step disease threshold that has to be surpassed to possibly trigger a seasonal
onset alarm. If the total number of cases in a window of size k exceeds \code{disease_threshold * k}, a seasonal
onset alarm can be triggered.}

\item{family}{A character string specifying the family for modeling}

\item{na_fraction_allowed}{Numeric value between 0 and 1 specifying the fraction of observables in the window
of size k that are allowed to be NA or zero, i.e. without cases, in onset calculations.}

\item{season_start, season_end}{Integers giving the start and end weeks of the seasons to
stratify the observations by. If set to \code{NULL}, it means no stratification by season.}

\item{only_current_season}{Should the output only include results for the current season?}
}
\value{
A \code{seasonal_onset} object containing:
\itemize{
\item 'reference_time': The time point for which the growth rate is estimated.
\item 'observation': The observation in the reference time point.
\item 'season': The stratification of observables in corresponding seasons.
\item 'growth_rate': The estimated growth rate.
\item 'lower_growth_rate': The lower bound of the growth rate's confidence interval.
\item 'upper_growth_rate': The upper bound of the growth rate's confidence interval.
\item 'growth_warning': Logical. Is the growth rate significantly higher than zero?
\item 'sum_of_cases': The sum of cases within the time window.
\item 'sum_of_cases_warning': Logical. Does the Sum of Cases exceed the disease threshold?
\item 'seasonal_onset_alarm': Logical. Is there a seasonal onset alarm?
\item 'skipped_window': Logical. Was the window skipped due to missing?
\item 'converged': Logical. Was the IWLS judged to have converged? - 'seasonal_onset': Logical. The first detected seasonal onset in the season?
}
}
\description{
This function performs automated and early detection of seasonal epidemic onsets on a time series dataset.
It estimates growth rates for consecutive time intervals and calculates the sum of cases (sum_of_cases).
}
\examples{
# Create a tibble object from sample data
tsd_data <- tsd(
  observation = c(100, 120, 150, 180, 220, 270),
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  time_interval = "day"
)

# Estimate seasonal onset with a 3-day window and a Poisson family model
seasonal_onset(
  tsd = tsd_data,
  k = 3,
  level = 0.95,
  disease_threshold = 20,
  family = "poisson",
  na_fraction_allowed = 0.4,
  season_start = NULL,
  season_end = NULL,
  only_current_season = NULL
)
}
