% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{add_spatial_coupling_to_ldata}
\alias{add_spatial_coupling_to_ldata}
\title{Add information about spatial coupling between nodes to 'ldata'}
\usage{
add_spatial_coupling_to_ldata(
  x,
  y,
  cutoff,
  ldata = NULL,
  min_dist = NULL,
  na_fail = TRUE
)
}
\arguments{
\item{x}{Projected x coordinate}

\item{y}{Projected y coordinate}

\item{cutoff}{The distance cutoff}

\item{ldata}{local data for the nodes. Can either be specified as
a \code{data.frame} with one row per node. Or as a matrix
where each column \code{ldata[, j]} contains the local data
vector for the node \code{j}. The local data vector is passed
as an argument to the transition rate functions and the post
time step function.}

\item{min_dist}{The minimum distance to separate two nodes.  If
the coordinates for two nodes are identical, the min_dist must
be assigned or an error is raised.  Default is \code{NULL},
i.e., to raise an error.}

\item{na_fail}{A logical indicating whether missing values in
\code{x} or \code{y} should raise an error or assign zero to
all distances involving missing values.  Default is
\code{TRUE}, i.e., to raise an error.}
}
\value{
matrix
}
\description{
A utility function to combine local model parameters
(\code{ldata}) and spatial coupling to other nodes and add the
result to \code{ldata}.
}
\details{
Format for ldata: the first n indicies (1, 2, ..., n) are the
local model parameters, i.e, the indata to the function. They are
followed by the neighbor data, pairs of (index, value) and then a
stop pair (-1, 0) where 'index' is the zero-based index to the
neighbor and the value is determined by the metric argument.
}
\examples{
ldata <- add_spatial_coupling_to_ldata(x = nodes$x,
                                       y = nodes$y,
                                       cutoff = 5000)
}
