% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stack.R
\name{Stack}
\alias{Stack}
\title{Stack columns from a data frame and include variables.}
\usage{
Stack(
  data,
  stackVar = 1:NCOL(data),
  blockVar = integer(0),
  rowData = data.frame(stackVar)[, integer(0), drop = FALSE],
  valueName = "values",
  indName = "ind"
)
}
\arguments{
\item{data}{A data frame}

\item{stackVar}{Indices of variables to be stacked}

\item{blockVar}{Indices of variables to be replicated}

\item{rowData}{A separate data frame where NROW(rowData)=length(stackVar)
such that each row may contain multiple information of each stackVar variable.
The output data frame will contain an extended variant of rowData.}

\item{valueName}{Name of the stacked/concatenated output variable}

\item{indName}{Name of the output variable with information of which vector in x the observation originated.
When indName is NULL this variable is not included in output.}
}
\value{
A data frame where the variable ordering corresponds to: blockVar, rowData, valueName, indName
}
\description{
Stack columns from a data frame and include variables.
}
\examples{

 z <- data.frame(n=c(10,20,30), ssb=c('S','S','B'),
 Ayes=1:3,Ano=4:6,Byes=7:9,Bno=10:12)
 zRow <- data.frame(letter=c('A','A','B','B'),answer=c('yes','no','yes','no') )
 
 x <- Stack(z,3:6,1:2,zRow)
 
 Unstack(x,6,3:4,numeric(0),1:2)
 Unstack(x,6,5,numeric(0),1:2)
 Unstack(x,6,3:4,5,1:2)
}
\seealso{
\code{\link{Unstack}}
}
\author{
Øyvind Langsrud
}
