% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.Shift.R
\docType{class}
\name{Shift}
\alias{Shift}
\title{Shift}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}}
}
\description{
Class to shift a dataset.
}
\details{
Transform autocorrelations to intervariables correlations
}
\section{Methods}{

\describe{
  \item{\code{new(lag,method,ref,)}}{This method is used to create object of this class with \code{Shift}}
  \item{\code{transform(X)}}{Method to shift a dataset}
  \item{\code{inverse(Xs)}}{Method to inverse the shift of a dataset}
}
}

\examples{
X = base::t(matrix( 1:20 , nrow = 2 , ncol = 10 ))

sh = Shift$new(1)
Xs = sh$transform(X)
Xi = sh$inverse(Xs)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lag}}{[integer] max lag for autocorrelations}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{method}}{[character] If inverse is by row or column.}

\item{\code{ref}}{[integer] reference column/row to inverse shift.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Shift-new}{\code{Shift$new()}}
\item \href{#method-Shift-transform}{\code{Shift$transform()}}
\item \href{#method-Shift-inverse}{\code{Shift$inverse()}}
\item \href{#method-Shift-clone}{\code{Shift$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Shift-new"></a>}}
\if{latex}{\out{\hypertarget{method-Shift-new}{}}}
\subsection{Method \code{new()}}{
Create a new Shift object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Shift$new(lag, method = "row", ref = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lag}}{[integer] max lag for autocorrelations}

\item{\code{method}}{[character] If "row" inverse by row, else by column}

\item{\code{ref}}{[integer] starting point for inverse transform}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Shift` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Shift-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Shift-transform}{}}}
\subsection{Method \code{transform()}}{
Shift the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Shift$transform(X)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{[matrix: n_samples * n_features] Data to shift}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix] Matrix shifted
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Shift-inverse"></a>}}
\if{latex}{\out{\hypertarget{method-Shift-inverse}{}}}
\subsection{Method \code{inverse()}}{
Inverse the shift of the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Shift$inverse(Xs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Xs}}{[matrix] Data Shifted}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix] Matrix un shifted
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Shift-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Shift-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Shift$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
