% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_rga.R
\name{plotly_rga}
\alias{plotly_rga}
\title{Interactive Reliability Growth Plot.}
\usage{
plotly_rga(
  rga_obj,
  showConf = TRUE,
  showGrid = TRUE,
  main = "Reliability Growth Plot",
  xlab = "Cumulative Time",
  ylab = "Cumulative Failures",
  pointCol = "black",
  fitCol = "black",
  confCol = "black",
  gridCol = "lightgray",
  breakCol = "black"
)
}
\arguments{
\item{rga_obj}{An object of class 'rga'. This object is created using the
`rga()` function from the `ReliaGrowR` package.}

\item{showConf}{Show the confidence bounds (TRUE) or not (FALSE).}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE).}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{pointCol}{Color of the point values.}

\item{fitCol}{Color of the model fit.}

\item{confCol}{Color of the confidence bounds.}

\item{gridCol}{Color of the grid.}

\item{breakCol}{Color of the breakpoints.}
}
\value{
The function returns no value. It generates an interactive plotly plot.
}
\description{
The function creates an interactive reliability growth plot for an `rga` object.
The plot includes cumulative failures over time, the model fit, and optional confidence bounds.
Vertical lines indicate change points if breakpoints are specified in the rga object.
}
\examples{
library(ReliaGrowR)
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
rga <- rga(times, failures)
plotly_rga(rga)

times <- c(100, 200, 300, 400, 500, 600, 700, 800, 900, 1000)
failures <- c(1, 2, 1, 1, 1, 2, 3, 1, 2, 4)
breakpoints <- 400
rga2 <- rga(times, failures, model_type = "Piecewise NHPP", breaks = breakpoints)
plotly_rga(rga2, fitCol = "blue", confCol = "blue", breakCol = "red")
}
