% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PqConnection.R
\name{postgresExportLargeObject}
\alias{postgresExportLargeObject}
\title{Exports a large object to file}
\usage{
postgresExportLargeObject(conn, oid, filepath)
}
\arguments{
\item{conn}{a \linkS4class{PqConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{oid}{the object identifier (Oid) of the large object to export}

\item{filepath}{a path where the large object should be exported}
}
\value{
invisible NULL on success, or stops with an error
}
\description{
Exports a large object from the database to a file on disk. This function
uses PostgreSQL's \code{lo_export()} function which efficiently streams the data
directly to disk without loading it into memory, making it suitable for
very large objects (GB+) that would cause memory issues with \code{lo_get()}.
This function must be called within a transaction.
}
\examples{
\dontrun{
con <- postgresDefault()
filepath <- 'your_image.png'
dbWithTransaction(con, {
  oid <- postgresImportLargeObject(con, filepath)
})
# Later, export the large object back to a file
dbWithTransaction(con, {
  postgresExportLargeObject(con, oid, 'exported_image.png')
})
}
}
