% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-1.layout.R
\name{transform_coors}
\alias{transform_coors}
\title{Transform the layout of a 'coors' object}
\usage{
transform_coors(
  coors,
  scale = 1,
  aspect_ratio = 1,
  rotation = 0,
  mirror_x = FALSE,
  mirror_y = FALSE,
  shear_x = 0,
  shear_y = 0
)
}
\arguments{
\item{coors}{An object of class 'coors', containing node coordinates.}

\item{scale}{A numeric value to scale the layout (default = 1).}

\item{aspect_ratio}{A numeric value to adjust the Y-axis scaling (default = 1).}

\item{rotation}{A numeric value in degrees to rotate the layout (default = 0).}

\item{mirror_x}{A logical value indicating whether to mirror along the X-axis (default = FALSE).}

\item{mirror_y}{A logical value indicating whether to mirror along the Y-axis (default = FALSE).}

\item{shear_x}{A numeric value to apply a shear transformation in the X direction (default = 0).}

\item{shear_y}{A numeric value to apply a shear transformation in the Y direction (default = 0).}
}
\value{
A transformed 'coors' object with updated coordinates.
}
\description{
This function applies various transformations to a 'coors' object, including
scaling, aspect ratio adjustment, rotation, mirroring, and pseudo-3D perspective transformation.
}
