% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{MCpval}
\alias{MCpval}
\title{Monte Carlo P-value}
\usage{
MCpval(test_stat, null_vec, type = "geq")
}
\arguments{
\item{test_stat}{Test statistic under the alternative (e.g. \code{S_0}).}

\item{null_vec}{A (\code{N x 1}) vector with test statistic under the null hypothesis.}

\item{type}{String determining type of test. options are: "geq" for right-tail test, "leq" for left-tail test, "abs" for absolute value test and "two-tail" for two-tail test.}
}
\value{
MC p-value of test
}
\description{
This function computes the Monte Carlo P-value.
}
\references{
Dufour, Jean-Marie 2006. "Monte Carlo tests with nuisance parameters: A general approach to finite-sample inference and nonstandard asymptotics". \emph{Journal of Econometrics}, 133(2), 443-477.

Dufour, Jean-Marie, and Richard Luger. 2017. "Identification-robust moment-based tests for Markov switching in autoregressive models". \emph{Econometric Reviews}, 36(6-9), 713-727.
}
