% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durations.R
\name{durations}
\alias{durations}
\title{Calculate duration of data in each group}
\usage{
durations(
  dataset,
  Variable.colname = Datetime,
  Datetime.colname = Datetime,
  count.NA = FALSE,
  show.missing = FALSE,
  show.interval = FALSE,
  FALSE.as.NA = FALSE
)
}
\arguments{
\item{dataset}{A light logger dataset. Expects a dataframe. If not imported
by LightLogR, take care to choose sensible variables for the
Datetime.colname and Variable.colname.}

\item{Variable.colname}{Column name that contains the variable for which to
calculate the duration. Expects a symbol. Needs to be part of the dataset.}

\item{Datetime.colname}{Column name that contains the datetime. Defaults to
"Datetime" which is automatically correct for data imported with LightLogR.
Expects a symbol. Needs to be part of the dataset. Must be of type POSIXct.}

\item{count.NA}{Logical. Should NA values in Variable.colname be counted as
part of the duration? Defaults to FALSE.}

\item{show.missing}{Logical. Should the duration of NAs be provided in a
separate column "Missing"? Defaults to FALSE.}

\item{show.interval}{Logical. Should the dominant epoch (interval) be shown
in a column "interval"? Defaults to FALSE.}

\item{FALSE.as.NA}{Logical. Should FALSE values in the Variable.colname be
treated as NA (i.e., missing)?}
}
\value{
A tibble with one row per group and a column "duration" containing
the duration of each group as a \code{\link[lubridate:duration]{lubridate::duration()}}. If \code{show.missing = TRUE}, a column "missing" is added with the duration of NAs, and a column
"total" with the total duration. If \code{show.interval = TRUE}, a column
"interval" is added with the dominant epoch of each group.
}
\description{
This function calculates the total duration of data in each group of a
dataset, based on a datetime column and a variable column. It uses the
dominant epoch (interval) of each group to calculate the duration.
}
\examples{
# Calculate the duration of a dataset
durations(sample.data.environment)

# create artificial gaps in the data
gapped_data <-
sample.data.environment |>
  dplyr::filter(MEDI >= 10) |>
  gap_handler(full.days = TRUE)

#by default, the Datetime column is selected for the `Variable.colname`, 
#basically ignoring NA measurement values
gapped_data |>
 durations(count.NA = TRUE)

# Calculate the duration where MEDI are available
durations(gapped_data, MEDI)

# Calculate the duration, show the duration of NAs separately
durations(gapped_data, MEDI, show.missing = TRUE)

# Calculate the duration, show the dominant epoch
durations(gapped_data, Variable.colname = MEDI, show.interval = TRUE)

# Calculate durations for day and night separately
gapped_data |>
  add_photoperiod(coordinates = c(48.52, 9.06)) |>
  dplyr::group_by(photoperiod.state, .add = TRUE) |>
  durations(Variable.colname = MEDI, show.interval = TRUE, show.missing = TRUE)
}
