% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EFAvote}
\alias{plot.EFAvote}
\title{Plot Voting Results for Number of Factors}
\usage{
\method{plot}{EFAvote}(x, ...)
}
\arguments{
\item{x}{An object of class \code{EFAvote}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function creates a pie chart to visualize the results of a voting method used to
determine the number of factors in exploratory factor analysis (EFA). The voting method combines
the results from multiple EFA techniques, and the pie chart displays the proportions of votes
each number of factors received. Each slice of the pie represents the percentage of votes
for a specific number of factors, providing a clear visual representation of the most
commonly suggested number of factors.
}
\examples{
library(EFAfactors)

\donttest{
nfacts <- c(5, 5, 5, 6, 6, 4)
names(nfacts) <- c("Hull", "CD", "PA", "EKC", "XGB","DNN")

EFAvote.obj <- EFAvote(votes = nfacts)
plot(EFAvote.obj)
}


}
\seealso{
\link[EFAfactors]{EFAvote}
}
