% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc.r
\docType{class}
\name{NlmeSimulationParams-class}
\alias{NlmeSimulationParams-class}
\alias{NlmeSimulationParams}
\title{Class initializer for NlmeSimulationParams}
\arguments{
\item{numReplicates}{Number of replicates to simulate}

\item{seed}{Random number generator seed}

\item{numPoints}{Number of points in simulation for the models in individual mode}

\item{maxXRange}{Maximum value of independent variable for the models in individual mode}

\item{yVariables}{Comma separated character string of Y variables for the models in individual mode}

\item{simAtObs}{Simulate values at observed values of ivar for the models in individual mode}

\item{simulationTables}{Optional list of simulation tables.
\code{NlmeSimTableDef} class instance or a list of such instances. Could be
generated by \code{tableParams} wrapper function or by \code{NlmeSimTableDef} class instance
initializing directly.}
}
\description{
Use to create set of parameters for simulation runs. Parameters \code{numPoints, maxXRange, yVariables, simAtObs}
are related to the model in individual mode. They will be outputted to
the file specified in \code{model@dataset@simoutFilename}, simout.csv by default
}
\examples{

table1 <- tableParams(
  name = "simulate.csv",
  timesList = "0,2,4,12,24",
  variablesList = "V,Cl",
  timeAfterDose = TRUE,
  forSimulation = TRUE
)

simParam <- NlmeSimulationParams(
  numReplicates = 10,
  seed = 29423,
  simulationTables = c(table1)
)

simParam <- NlmeSimulationParams(
  numPoints = 100,
  maxXRange = 50,
  yVariables = "C,A1",
  simulationTables = table1
)

}
\seealso{
\code{\link{tableParams}, \link{NlmeSimTableDef}}
}
\keyword{internal}
