% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pml_model.r
\docType{class}
\name{NlmePmlModel-class}
\alias{NlmePmlModel-class}
\alias{NlmePmlModel}
\title{Class initializaer for NlmePmlModel object}
\description{
The following class represents an NLME/PML model object.
}
\section{Slots}{

\describe{
\item{\code{isPopulation}}{Is this a population model (TRUE) or
individual (FALSE)?}

\item{\code{modelType}}{Taken from NlmeModelType}

\item{\code{isTimeBased}}{Is model time-based?}

\item{\code{linearModelType}}{Type of linear model}

\item{\code{isLinearFrozen}}{Is linear model frozen?}

\item{\code{pkModelAttrs}}{Taken from NlmePkParameters}

\item{\code{indirectModelAttrs}}{Taken from NlmeIndirectParameters}

\item{\code{emaxModelAttrs}}{Taken from NlmeEmaxParameters}

\item{\code{hasEffectsCompartment}}{Is there data available for an effects compartment?}

\item{\code{errorModel}}{Taken from NlmeErrorModel}

\item{\code{structuralParams}}{List of structural parameters}

\item{\code{outputParams}}{List of output parameters}

\item{\code{diffEquations}}{List of differential equations}

\item{\code{statements}}{List of PML statements}

\item{\code{dosePoints}}{List of dosepoints}

\item{\code{covariateList}}{List of covariates}

\item{\code{columnMapping}}{Taken from NlmeColumnMapping}

\item{\code{doseMapping}}{Taken from NlmeDoseMapping}

\item{\code{paramsMapping}}{Taken from NlmeParamsMapping}

\item{\code{randParamsMapping}}{Taken from NlmeRandParamsMapping}

\item{\code{inputData}}{Input data source}

\item{\code{doseData}}{Dose data source}

\item{\code{fixedParamData}}{Fixed effect parameter data source}

\item{\code{randParamData}}{Random effect parameter data source}

\item{\code{isTextual}}{Is model textual (TRUE) or graphical (FALSE)?}

\item{\code{pmloutput}}{List of PML output to generate}

\item{\code{modelInfo}}{Taken from NlmePmlModelInfo}

\item{\code{objects}}{deprecated}

\item{\code{objectsNeedRegenerating}}{deprecated}

\item{\code{randomEffectsStatements}}{Custom random effects statements}

\item{\code{randomOccasionalEffectsStatements}}{Custom random occasional effects statements}

\item{\code{userDefinedExtraDefs}}{Custom definition for extra column
and table generation}
}}

\examples{
\donttest{
# helper class
setClass("NlmePmlModelInfo",
         slots = c(modelName = "character",
                   workingDir = "character"))
Model <-
  new("NlmePmlModel",
  modelInfo = new("NlmePmlModelInfo", modelName = "Model", workingDir = "."))
}

}
\keyword{internal}
