% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pml_model.r
\name{initFixedEffects}
\alias{initFixedEffects}
\alias{initFixedEffects,NlmePmlModel-method}
\alias{initFixedEffects<-}
\alias{initFixedEffects<-,NlmePmlModel-method}
\title{Display/Set initial estimates for fixed effects}
\usage{
initFixedEffects(.Object)

\S4method{initFixedEffects}{NlmePmlModel}(.Object)

initFixedEffects(.Object) <- value

\S4method{initFixedEffects}{NlmePmlModel}(.Object) <- value
}
\arguments{
\item{.Object}{PK/PD model}

\item{value}{Named numeric vector}
}
\value{
Named numeric vector of fixed effects estimates
}
\description{
Display/Set initial estimates for fixed effects
}
\examples{
model <- pkmodel(
  numCompartments = 2,
  data = pkData,
  ID = "Subject",
  Time = "Act_Time",
  A1 = "Amount",
  CObs = "Conc",
  modelName = "TwCpt_IVBolus_FOCE_ELS"
  )

# View initial/current fixed effect values
 initFixedEffects(model)

# May also use as a 'replacement function' to set the values
initFixedEffects(model) <- c(tvV = 15, tvCl = 5, tvV2 = 40, tvCl2 = 15)

}
\seealso{
\code{\link{fixedEffect}}
}
