/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PowerTransformParser
extends AbstractXMLObjectParser {
    public static final String POWER_TRANSFORM = "powerTransform";
    private static final String POWER = "power";

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Transform.ParsedTransform parsedTransform = (Transform.ParsedTransform)xMLObject.getChild(Transform.ParsedTransform.class);
        if (!(parsedTransform.transform instanceof Transform.PowerTransform)) {
            throw new XMLParseException("The 'type' attribute of the transform xml element must be '" + Transform.Type.POWER.getName() + "'.");
        }
        double d = xMLObject.getDoubleAttribute(POWER);
        parsedTransform.transform = new Transform.PowerTransform(d);
        return parsedTransform;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newDoubleRule(POWER), new ElementRule(Transform.ParsedTransform.class)};
    }

    @Override
    public String getParserDescription() {
        return "Raises a parameter to a given power.";
    }

    @Override
    public Class getReturnType() {
        return Transform.ParsedTransform.class;
    }

    @Override
    public String getParserName() {
        return POWER_TRANSFORM;
    }
}

