% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\name{newMultiPop}
\alias{newMultiPop}
\title{Create new Multi Population}
\usage{
newMultiPop(...)
}
\arguments{
\item{...}{one or more \code{\link{Pop-class}} and/or
\code{\link{MultiPop-class}} objects.}
}
\value{
Returns an object of \code{\link{MultiPop-class}}
}
\description{
Creates a new \code{\link{MultiPop-class}} from one or more
\code{\link{Pop-class}} and/or \code{\link{MultiPop-class}}
objects.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
megaPop = newMultiPop(pop=pop)
isMultiPop(megaPop)

}
