% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sort.R
\docType{methods}
\name{sort.list}
\alias{sort.list}
\alias{sort.list,MCMC-method}
\alias{sort.list,PhasesMCMC-method}
\title{Ordering Permutation of an MCMC Object}
\usage{
\S4method{sort.list}{MCMC}(x, decreasing = FALSE)

\S4method{sort.list}{PhasesMCMC}(x, decreasing = FALSE)
}
\arguments{
\item{x}{An \code{\linkS4class{MCMC}} object.}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order be decreasing?}
}
\value{
An \code{\link{integer}} vector.
}
\description{
Returns a permutation which rearranges an object into ascending or descending
temporal order.
}
\examples{
## Events
(eve <- as_events(mcmc_events, calendar = CE(), iteration = 1))

eve[1:1000, ] # Select the first 1000 iterations
eve[, 1:2]    # Select the first 2 events

cbind2(eve[, 1:2], eve[, 3:4]) # Combine two MCMC objects
sort(eve, decreasing = TRUE)   # Sort events in descending order

## Phases
(pha <- as_phases(mcmc_phases, start = c(1, 3), calendar = CE(), iteration = 1))

pha[1:1000, , ]          # Select the first 1000 iterations
pha[, 1, , drop = FALSE] # Select the first phase
}
\seealso{
Other mutators: 
\code{\link{bind}},
\code{\link{data.frame}},
\code{\link{names}()},
\code{\link{sort}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
