% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popSummary.R
\name{parentAverage}
\alias{parentAverage}
\title{Calculate parent average}
\usage{
parentAverage(
  pop,
  parents = NULL,
  mothers = NULL,
  fathers = NULL,
  use = "gv",
  simParam = NULL
)
}
\arguments{
\item{pop}{\code{\link{Pop-class}} with individuals whose parent average
will be calculated}

\item{parents}{\code{\link{Pop-class}} with mothers and fathers of individuals
in \code{pop}; if \code{NULL} must provide \code{mothers} and \code{fathers}}

\item{mothers}{\code{\link{Pop-class}} with mothers of individuals in \code{pop};
if \code{NULL} must provide \code{parents}}

\item{fathers}{\code{\link{Pop-class}} with fathers of individuals in \code{pop};
if \code{NULL} must provide \code{parents}}

\item{use}{character, calculate using \code{"\link{gv}"}, \code{"\link{bv}"},
\code{"\link{ebv}"}, or \code{"\link{pheno}"}}

\item{simParam}{\code{\link{SimParam}} object}
}
\value{
a matrix of parent averages with dimensions nInd by nTraits
}
\description{
Calculate parent average
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitAD(10, meanDD=0.5)
SP$setVarE(h2=0.5)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
pop2 = randCross(pop, nCrosses=10, nProgeny=2)
parentAverage(pop2, parents = pop)
parentAverage(pop2, mothers = pop, fathers = pop)

}
