% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOPA-functions.R
\name{Transformations}
\alias{Transformations}
\alias{A}
\alias{varA}
\alias{Atrans}
\alias{SE.Atrans}
\alias{var.Atrans}
\alias{CI.Atrans}
\alias{prop}
\alias{CI.prop}
\title{Transformation functions}
\usage{
A(s, n)

varA(s, n)

Atrans(v)

SE.Atrans(v)

var.Atrans(v)

CI.Atrans(v, gamma)

prop(v)

CI.prop(v, gamma)
}
\arguments{
\item{s}{a number of success;}

\item{n}{a number of trials.}

\item{v}{a vector of 0s and 1s.}

\item{gamma}{a confidence level, default to .95 when omitted.}
}
\value{
\code{A()} returns a score between 0 and 1.57 where a \code{s} of zero results in
\code{A(0,n)} tending to zero when the number of trials is large,
and where the maximum occurs when \code{s} equals \code{n} and
are both very large, so that for example \code{A(1000,1000) = 1.55}. The
midpoint is always 0.786 irrespective of the number of trials
\code{A(0.5 * n, n) = 0.786}.
The function \code{varA()} returns the theoretical variance of an Anscombe
transformed score. It is exact as \code{n} gets large, and overestimate variance
when \code{n} is small. Therefore, a test based on this transform is either exact
or conservative.
}
\description{
The transformation functions \code{A()} performs the
Anscombe transformation on a pair \{number of success; number
of trials\} = \{s; n\} (where the symbol ";" is to be read "over".
The function \code{varA()} returns the theoretical variance from
the pair \{s; n\}. Both functions are central to the ANOPA
\insertCite{lc23}{ANOPA}. It was originally proposed by
\insertCite{z35}{ANOPA} and formalized by \insertCite{a48}{ANOPA}.
}
\details{
The functions \code{A()} and \code{varA()} take as input two integers, \code{s}
the number of success and \code{n} the number of observations.
The functions \code{Atrans()}, \code{SE.Atrans()}, \code{var.Atrans()}, \code{CI.Atrans()}, \code{prop()} and \code{CI.prop()}
take as input a single vector \code{v} of 0s and 1s from which the number of
success and the number of observations are derived.
}
\examples{
# The transformations from number of 1s and total number of observations:
A(5, 10)
 
varA(5, 10)
 
# Same with a vector of observations:
Atrans( c(1,1,1,1,1,0,0,0,0,0) )
 
var.Atrans( c(1,1,1,1,1,0,0,0,0,0) )
 


}
\references{
\insertAllCited
}
