% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_VFTimeSeries.R
\name{PlotVfTimeSeries}
\alias{PlotVfTimeSeries}
\title{PlotVfTimeSeries}
\usage{
PlotVfTimeSeries(
  Y,
  Location,
  Time,
  main = "Visual field sensitivity time series \\n at each location",
  xlab = "Time from first visit (days)",
  ylab = "Sensitivity (dB)",
  line.col = "red",
  line.reg = TRUE,
  line.type = 1
)
}
\arguments{
\item{Y}{a time series variable to be plotted.}

\item{Location}{a variable corresponding to the location on the visual field
that the time series variable was observed.}

\item{Time}{a variable corresponding to the time that the time series variable
was observed.}

\item{main}{an overall title for the plot.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{line.col}{color for the regression line, either character string corresponding
to a color or a integer (default = "red").}

\item{line.reg}{logical, determines if there are regression lines printed (default = TRUE).}

\item{line.type}{integer, specifies the type of regression line printed (default = 1).}
}
\description{
Plots a time series at each location of the Humphrey Field Analyzer-II visual field .
}
\details{
\code{PlotVfTimeSeries} is used in the application of glaucoma progression.
 In each cell is the observed DLS at each location over visits, with the red line
 representing a linear regression trend.
}
\examples{
data(VFSeries)
PlotVfTimeSeries(Y = VFSeries$DLS,
                  Location = VFSeries$Location,
                  Time = VFSeries$Time,
                  main = "Visual field sensitivity time series \n at each location",
                  xlab = "Days from baseline visit",
                  ylab = "Differential light sensitivity (dB)")


}
\author{
Samuel I. Berchuck
}
