% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{wbt_random_forest_classification}
\alias{wbt_random_forest_classification}
\title{Random forest classification}
\usage{
wbt_random_forest_classification(
  inputs,
  training,
  field,
  output = NULL,
  split_criterion = "Gini",
  n_trees = 500,
  min_samples_leaf = 1,
  min_samples_split = 2,
  test_proportion = 0.2,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Names of the input predictor rasters.}

\item{training}{Name of the input training site polygons/points shapefile.}

\item{field}{Name of the attribute containing class data.}

\item{output}{Name of the output raster file.}

\item{split_criterion}{Split criterion to use when building a tree. Options include 'Gini', 'Entropy', and 'ClassificationError'.}

\item{n_trees}{The number of trees in the forest.}

\item{min_samples_leaf}{The minimum number of samples required to be at a leaf node.}

\item{min_samples_split}{The minimum number of samples required to split an internal node.}

\item{test_proportion}{The proportion of the dataset to include in the test split; default is 0.2.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a supervised random forest classification using training site polygons/points and predictor rasters.
}
\keyword{MachineLearning}
